/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.cache.h2;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.server.cache.CacheBinding;
import com.google.gerrit.server.cache.PersistentCacheFactory;
import com.google.gerrit.server.cache.h2.DefaultCacheFactory;
import com.google.gerrit.server.cache.h2.H2CacheImpl;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.plugins.Plugin;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class H2CacheFactory
implements PersistentCacheFactory,
LifecycleListener {
    static final Logger log = LoggerFactory.getLogger(H2CacheFactory.class);
    private final DefaultCacheFactory defaultFactory;
    private final Config config;
    private final File cacheDir;
    private final List<H2CacheImpl<?, ?>> caches;
    private final DynamicMap<Cache<?, ?>> cacheMap;
    private final ExecutorService executor;
    private final ScheduledExecutorService cleanup;

    @Inject
    H2CacheFactory(DefaultCacheFactory defaultCacheFactory, @GerritServerConfig Config cfg, SitePaths site, DynamicMap<Cache<?, ?>> cacheMap) {
        this.defaultFactory = defaultCacheFactory;
        this.config = cfg;
        File loc = site.resolve(cfg.getString("cache", null, "directory"));
        if (loc == null) {
            this.cacheDir = null;
        } else if (loc.exists() || loc.mkdirs()) {
            if (loc.canWrite()) {
                log.info("Enabling disk cache " + loc.getAbsolutePath());
                this.cacheDir = loc;
            } else {
                log.warn("Can't write to disk cache: " + loc.getAbsolutePath());
                this.cacheDir = null;
            }
        } else {
            log.warn("Can't create disk cache: " + loc.getAbsolutePath());
            this.cacheDir = null;
        }
        this.caches = Lists.newLinkedList();
        this.cacheMap = cacheMap;
        if (this.cacheDir != null) {
            this.executor = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("DiskCache-Store-%d").build());
            this.cleanup = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("DiskCache-Prune-%d").setDaemon(true).build());
        } else {
            this.executor = null;
            this.cleanup = null;
        }
    }

    @Override
    public void start() {
        if (this.executor != null) {
            for (final H2CacheImpl<?, ?> cache : this.caches) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        cache.start();
                    }
                });
                this.cleanup.schedule(new Runnable(){

                    @Override
                    public void run() {
                        cache.prune(H2CacheFactory.this.cleanup);
                    }
                }, 30L, TimeUnit.SECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.executor != null) {
            try {
                this.cleanup.shutdownNow();
                List<Runnable> pending = this.executor.shutdownNow();
                if (this.executor.awaitTermination(15L, TimeUnit.MINUTES)) {
                    if (pending != null && !pending.isEmpty()) {
                        log.info(String.format("Finishing %d disk cache updates", pending.size()));
                        for (Runnable update : pending) {
                            update.run();
                        }
                    }
                } else {
                    log.info("Timeout waiting for disk cache to close");
                }
            }
            catch (InterruptedException e) {
                log.warn("Interrupted waiting for disk cache to shutdown");
            }
        }
        List<H2CacheImpl<?, ?>> list = this.caches;
        synchronized (list) {
            for (H2CacheImpl<?, ?> cache : this.caches) {
                cache.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> Cache<K, V> build(CacheBinding<K, V> def) {
        long limit = this.config.getLong("cache", def.name(), "diskLimit", 0x8000000L);
        if (this.cacheDir == null || limit <= 0L) {
            return this.defaultFactory.build(def);
        }
        H2CacheImpl.SqlStore<K, V> store = this.newSqlStore(def.name(), def.keyType(), limit, def.expireAfterWrite(TimeUnit.SECONDS));
        H2CacheImpl<K, V> cache = new H2CacheImpl<K, V>(this.executor, store, def.keyType(), this.defaultFactory.create(def, true).build());
        List<H2CacheImpl<?, ?>> list = this.caches;
        synchronized (list) {
            this.caches.add(cache);
        }
        return cache;
    }

    @Override
    public <K, V> LoadingCache<K, V> build(CacheBinding<K, V> def, CacheLoader<K, V> loader) {
        long limit = this.config.getLong("cache", def.name(), "diskLimit", 0x8000000L);
        if (this.cacheDir == null || limit <= 0L) {
            return this.defaultFactory.build(def, loader);
        }
        H2CacheImpl.SqlStore<K, V> store = this.newSqlStore(def.name(), def.keyType(), limit, def.expireAfterWrite(TimeUnit.SECONDS));
        LoadingCache<K, V> mem = this.defaultFactory.create(def, true).build(new H2CacheImpl.Loader<K, V>(this.executor, store, loader));
        H2CacheImpl<K, V> cache = new H2CacheImpl<K, V>(this.executor, store, def.keyType(), mem);
        this.caches.add(cache);
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop(Plugin plugin) {
        List<H2CacheImpl<?, ?>> list = this.caches;
        synchronized (list) {
            for (Map.Entry<String, Provider<Cache<?, ?>>> entry : this.cacheMap.byPlugin(plugin.getName()).entrySet()) {
                Cache<?, ?> cache = entry.getValue().get();
                if (!this.caches.remove(cache)) continue;
                ((H2CacheImpl)cache).stop();
            }
        }
    }

    private <V, K> H2CacheImpl.SqlStore<K, V> newSqlStore(String name, TypeLiteral<K> keyType, long maxSize, Long expireAfterWrite) {
        File db = new File(this.cacheDir, name).getAbsoluteFile();
        String url = "jdbc:h2:" + db.toURI().toString();
        return new H2CacheImpl.SqlStore(url, keyType, maxSize, expireAfterWrite == null ? 0L : expireAfterWrite);
    }
}

