/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AcceptsPost;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestCollection;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.ChangeTriplet;
import com.google.gerrit.server.change.CreateChange;
import com.google.gerrit.server.index.ChangeIndexer;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.query.change.QueryChanges;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

@Singleton
public class ChangesCollection
implements RestCollection<TopLevelResource, ChangeResource>,
AcceptsPost<TopLevelResource> {
    private final Provider<ReviewDb> db;
    private final Provider<CurrentUser> user;
    private final ChangeControl.GenericFactory changeControlFactory;
    private final Provider<QueryChanges> queryFactory;
    private final DynamicMap<RestView<ChangeResource>> views;
    private final CreateChange createChange;
    private final ChangeIndexer changeIndexer;

    @Inject
    ChangesCollection(Provider<ReviewDb> dbProvider, Provider<CurrentUser> user, ChangeControl.GenericFactory changeControlFactory, Provider<QueryChanges> queryFactory, DynamicMap<RestView<ChangeResource>> views, CreateChange createChange, ChangeIndexer changeIndexer) {
        this.db = dbProvider;
        this.user = user;
        this.changeControlFactory = changeControlFactory;
        this.queryFactory = queryFactory;
        this.views = views;
        this.createChange = createChange;
        this.changeIndexer = changeIndexer;
    }

    public QueryChanges list() {
        return this.queryFactory.get();
    }

    @Override
    public DynamicMap<RestView<ChangeResource>> views() {
        return this.views;
    }

    @Override
    public ChangeResource parse(TopLevelResource root, IdString id) throws ResourceNotFoundException, OrmException {
        ChangeControl control;
        Integer changeId;
        List<Change> changes = this.findChanges(id.encoded());
        if (changes.isEmpty() && (changeId = Ints.tryParse(id.get())) != null) {
            try {
                this.changeIndexer.delete(changeId);
            }
            catch (IOException e) {
                throw new ResourceNotFoundException(id.get(), e);
            }
        }
        if (changes.size() != 1) {
            throw new ResourceNotFoundException(id);
        }
        try {
            control = this.changeControlFactory.validateFor(changes.get(0), this.user.get());
        }
        catch (NoSuchChangeException e) {
            throw new ResourceNotFoundException(id);
        }
        return new ChangeResource(control);
    }

    public ChangeResource parse(Change.Id id) throws ResourceNotFoundException, OrmException {
        return this.parse(TopLevelResource.INSTANCE, IdString.fromUrl(Integer.toString(id.get())));
    }

    public ChangeResource parse(ChangeControl control) throws OrmException {
        return new ChangeResource(control);
    }

    private List<Change> findChanges(String id) throws OrmException, ResourceNotFoundException {
        ChangeTriplet triplet;
        if (id.matches("^[1-9][0-9]*$")) {
            Change c = this.db.get().changes().get(Change.Id.parse(id));
            if (c != null) {
                return ImmutableList.of(c);
            }
            return Collections.emptyList();
        }
        if (!id.contains("~")) {
            Change.Key key = new Change.Key(id);
            if (key.get().length() == 41) {
                return this.db.get().changes().byKey(key).toList();
            }
            return this.db.get().changes().byKeyRange(key, key.max()).toList();
        }
        try {
            triplet = new ChangeTriplet(id);
        }
        catch (ChangeTriplet.ParseException e) {
            throw new ResourceNotFoundException(id);
        }
        return this.db.get().changes().byBranchKey(triplet.getBranchNameKey(), triplet.getChangeKey()).toList();
    }

    public CreateChange post(TopLevelResource parent) throws RestApiException {
        return this.createChange;
    }
}

