/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.PatchLineCommentsUtil;
import com.google.gerrit.server.change.CommentResource;
import com.google.gerrit.server.change.ListComments;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
class Comments
implements ChildCollection<RevisionResource, CommentResource> {
    private final DynamicMap<RestView<CommentResource>> views;
    private final ListComments list;
    private final Provider<ReviewDb> dbProvider;
    private final PatchLineCommentsUtil plcUtil;

    @Inject
    Comments(DynamicMap<RestView<CommentResource>> views, ListComments list, Provider<ReviewDb> dbProvider, PatchLineCommentsUtil plcUtil) {
        this.views = views;
        this.list = list;
        this.dbProvider = dbProvider;
        this.plcUtil = plcUtil;
    }

    @Override
    public DynamicMap<RestView<CommentResource>> views() {
        return this.views;
    }

    @Override
    public RestView<RevisionResource> list() {
        return this.list;
    }

    @Override
    public CommentResource parse(RevisionResource rev, IdString id) throws ResourceNotFoundException, OrmException {
        String uuid = id.get();
        ChangeNotes notes = rev.getNotes();
        for (PatchLineComment c : this.plcUtil.publishedByPatchSet(this.dbProvider.get(), notes, rev.getPatchSet().getId())) {
            if (!uuid.equals(c.getKey().get())) continue;
            return new CommentResource(rev, c);
        }
        throw new ResourceNotFoundException(id);
    }
}

