/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Strings;
import com.google.gerrit.common.data.Capable;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.common.ChangeStatus;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.api.changes.ChangeInfoMapper;
import com.google.gerrit.server.change.ChangeInserter;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.events.CommitReceivedEvent;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MergeUtil;
import com.google.gerrit.server.git.validators.CommitValidationException;
import com.google.gerrit.server.git.validators.CommitValidators;
import com.google.gerrit.server.project.InvalidChangeOperationException;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.ProjectsCollection;
import com.google.gerrit.server.project.RefControl;
import com.google.gerrit.server.ssh.NoSshInfo;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Timestamp;
import java.util.List;
import java.util.TimeZone;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.util.ChangeIdUtil;

@Singleton
public class CreateChange
implements RestModifyView<TopLevelResource, ChangeInfo> {
    private final Provider<ReviewDb> db;
    private final GitRepositoryManager gitManager;
    private final TimeZone serverTimeZone;
    private final Provider<CurrentUser> userProvider;
    private final ProjectsCollection projectsCollection;
    private final CommitValidators.Factory commitValidatorsFactory;
    private final ChangeInserter.Factory changeInserterFactory;
    private final ChangeJson json;

    @Inject
    CreateChange(Provider<ReviewDb> db, GitRepositoryManager gitManager, @GerritPersonIdent PersonIdent myIdent, Provider<CurrentUser> userProvider, ProjectsCollection projectsCollection, CommitValidators.Factory commitValidatorsFactory, ChangeInserter.Factory changeInserterFactory, ChangeJson json) {
        this.db = db;
        this.gitManager = gitManager;
        this.serverTimeZone = myIdent.getTimeZone();
        this.userProvider = userProvider;
        this.projectsCollection = projectsCollection;
        this.commitValidatorsFactory = commitValidatorsFactory;
        this.changeInserterFactory = changeInserterFactory;
        this.json = json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response<ChangeJson.ChangeInfo> apply(TopLevelResource parent, ChangeInfo input) throws AuthException, OrmException, BadRequestException, UnprocessableEntityException, IOException, InvalidChangeOperationException {
        ProjectResource rsrc;
        Capable r;
        if (Strings.isNullOrEmpty(input.project)) {
            throw new BadRequestException("project must be non-empty");
        }
        if (Strings.isNullOrEmpty(input.branch)) {
            throw new BadRequestException("branch must be non-empty");
        }
        if (Strings.isNullOrEmpty(input.subject)) {
            throw new BadRequestException("commit message must be non-empty");
        }
        if (input.status != null && input.status != ChangeStatus.NEW && input.status != ChangeStatus.DRAFT) {
            throw new BadRequestException("unsupported change status");
        }
        String refName = input.branch;
        if (!refName.startsWith("refs/")) {
            refName = "refs/heads/" + input.branch;
        }
        if ((r = (rsrc = this.projectsCollection.parse(input.project)).getControl().canPushToAtLeastOneRef()) != Capable.OK) {
            throw new AuthException(r.getMessage());
        }
        RefControl refControl = rsrc.getControl().controlForRef(refName);
        if (!refControl.canUpload() || !refControl.canRead()) {
            throw new AuthException("cannot upload review");
        }
        Project.NameKey project = rsrc.getNameKey();
        try (Repository git = this.gitManager.openRepository(project);){
            RevWalk rw = new RevWalk(git);
            try {
                Ref destRef = git.getRef(refName);
                if (destRef == null) {
                    throw new UnprocessableEntityException(String.format("Branch %s does not exist.", refName));
                }
                Timestamp now = TimeUtil.nowTs();
                IdentifiedUser me = (IdentifiedUser)this.userProvider.get();
                PersonIdent author = me.newCommitterIdent(now, this.serverTimeZone);
                RevCommit mergeTip = rw.parseCommit(destRef.getObjectId());
                ObjectId id = ChangeIdUtil.computeChangeId(mergeTip.getTree(), mergeTip, author, author, input.subject);
                String commitMessage = ChangeIdUtil.insertId(input.subject, id);
                RevCommit c = CreateChange.newCommit(git, rw, author, mergeTip, commitMessage);
                Change change = new Change(CreateChange.getChangeId(id, c), new Change.Id(this.db.get().nextChangeId()), me.getAccountId(), new Branch.NameKey(project, destRef.getName()), now);
                ChangeInserter ins = this.changeInserterFactory.create(refControl, change, c);
                this.validateCommit(git, refControl, c, me, ins);
                CreateChange.updateRef(git, rw, c, change, ins.getPatchSet());
                change.setTopic(input.topic);
                change.setStatus(ChangeInfoMapper.changeStatus2Status(input.status));
                ins.insert();
                Response<ChangeJson.ChangeInfo> response = Response.created(this.json.format(change.getId()));
                rw.release();
                return response;
            }
            catch (Throwable throwable) {
                rw.release();
                throw throwable;
            }
        }
    }

    private void validateCommit(Repository git, RefControl refControl, RevCommit c, IdentifiedUser me, ChangeInserter ins) throws InvalidChangeOperationException {
        PatchSet newPatchSet = ins.getPatchSet();
        CommitValidators commitValidators = this.commitValidatorsFactory.create(refControl, new NoSshInfo(), git);
        CommitReceivedEvent commitReceivedEvent = new CommitReceivedEvent(new ReceiveCommand(ObjectId.zeroId(), c.getId(), newPatchSet.getRefName()), refControl.getProjectControl().getProject(), refControl.getRefName(), c, me);
        try {
            commitValidators.validateForGerritCommits(commitReceivedEvent);
        }
        catch (CommitValidationException e) {
            throw new InvalidChangeOperationException(e.getMessage());
        }
    }

    private static void updateRef(Repository git, RevWalk rw, RevCommit c, Change change, PatchSet newPatchSet) throws IOException {
        RefUpdate ru = git.updateRef(newPatchSet.getRefName());
        ru.setExpectedOldObjectId(ObjectId.zeroId());
        ru.setNewObjectId(c);
        ru.disableRefLog();
        if (ru.update(rw) != RefUpdate.Result.NEW) {
            throw new IOException(String.format("Failed to create ref %s in %s: %s", new Object[]{newPatchSet.getRefName(), change.getDest().getParentKey().get(), ru.getResult()}));
        }
    }

    private static Change.Key getChangeId(ObjectId id, RevCommit emptyCommit) {
        List<String> idList = emptyCommit.getFooterLines(MergeUtil.CHANGE_ID);
        Change.Key changeKey = !idList.isEmpty() ? new Change.Key(idList.get(idList.size() - 1).trim()) : new Change.Key("I" + id.name());
        return changeKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RevCommit newCommit(Repository git, RevWalk rw, PersonIdent authorIdent, RevCommit mergeTip, String commitMessage) throws IOException {
        RevCommit emptyCommit;
        ObjectInserter oi = git.newObjectInserter();
        try {
            CommitBuilder commit = new CommitBuilder();
            commit.setTreeId(mergeTip.getTree().getId());
            commit.setParentId(mergeTip);
            commit.setAuthor(authorIdent);
            commit.setCommitter(authorIdent);
            commit.setMessage(commitMessage);
            emptyCommit = rw.parseCommit(CreateChange.insert(oi, commit));
        }
        finally {
            oi.release();
        }
        return emptyCommit;
    }

    private static ObjectId insert(ObjectInserter inserter, CommitBuilder commit) throws IOException, UnsupportedEncodingException {
        ObjectId id = inserter.insert(commit);
        inserter.flush();
        return id;
    }
}

