/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Strings;
import com.google.gerrit.common.changes.Side;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.Patch;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.change.CommentInfo;
import com.google.gerrit.server.change.PutDraft;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Collections;

@Singleton
class CreateDraft
implements RestModifyView<RevisionResource, PutDraft.Input> {
    private final Provider<ReviewDb> db;

    @Inject
    CreateDraft(Provider<ReviewDb> db) {
        this.db = db;
    }

    public Response<CommentInfo> apply(RevisionResource rsrc, PutDraft.Input in) throws BadRequestException, OrmException {
        if (Strings.isNullOrEmpty(in.path)) {
            throw new BadRequestException("path must be non-empty");
        }
        if (in.message == null || in.message.trim().isEmpty()) {
            throw new BadRequestException("message must be non-empty");
        }
        if (in.line != null && in.line <= 0) {
            throw new BadRequestException("line must be > 0");
        }
        if (in.line != null && in.range != null && in.line.intValue() != in.range.getEndLine()) {
            throw new BadRequestException("range endLine must be on the same line as the comment");
        }
        int line = in.line != null ? in.line : (in.range != null ? in.range.getEndLine() : 0);
        PatchLineComment c = new PatchLineComment(new PatchLineComment.Key(new Patch.Key(rsrc.getPatchSet().getId(), in.path), ChangeUtil.messageUUID(this.db.get())), line, rsrc.getAccountId(), Url.decode(in.inReplyTo), TimeUtil.nowTs());
        c.setSide(in.side == Side.PARENT ? (short)0 : 1);
        c.setMessage(in.message.trim());
        c.setRange(in.range);
        this.db.get().patchComments().insert(Collections.singleton(c));
        return Response.created(new CommentInfo(c, null));
    }
}

