/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.Lists;
import com.google.gerrit.extensions.api.changes.ReviewInput;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.git.EmailReviewCommentsExecutor;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.server.mail.CommentSender;
import com.google.gerrit.server.patch.PatchSetInfoFactory;
import com.google.gerrit.server.util.RequestContext;
import com.google.gerrit.server.util.ThreadLocalRequestContext;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.assistedinject.Assisted;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailReviewComments
implements Runnable,
RequestContext {
    private static final Logger log = LoggerFactory.getLogger(EmailReviewComments.class);
    private final WorkQueue.Executor sendEmailsExecutor;
    private final PatchSetInfoFactory patchSetInfoFactory;
    private final CommentSender.Factory commentSenderFactory;
    private final SchemaFactory<ReviewDb> schemaFactory;
    private final ThreadLocalRequestContext requestContext;
    private final ReviewInput.NotifyHandling notify;
    private final Change change;
    private final PatchSet patchSet;
    private final Account.Id authorId;
    private final ChangeMessage message;
    private List<PatchLineComment> comments;
    private ReviewDb db;

    @Inject
    EmailReviewComments(@EmailReviewCommentsExecutor WorkQueue.Executor executor, PatchSetInfoFactory patchSetInfoFactory, CommentSender.Factory commentSenderFactory, SchemaFactory<ReviewDb> schemaFactory, ThreadLocalRequestContext requestContext, @Assisted ReviewInput.NotifyHandling notify, @Assisted Change change, @Assisted PatchSet patchSet, @Assisted Account.Id authorId, @Assisted ChangeMessage message, @Assisted List<PatchLineComment> comments) {
        this.sendEmailsExecutor = executor;
        this.patchSetInfoFactory = patchSetInfoFactory;
        this.commentSenderFactory = commentSenderFactory;
        this.schemaFactory = schemaFactory;
        this.requestContext = requestContext;
        this.notify = notify;
        this.change = change;
        this.patchSet = patchSet;
        this.authorId = authorId;
        this.message = message;
        this.comments = comments;
    }

    void sendAsync() {
        this.sendEmailsExecutor.submit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.requestContext.setContext(this);
            this.comments = Lists.newArrayList(this.comments);
            Collections.sort(this.comments, new Comparator<PatchLineComment>(){

                @Override
                public int compare(PatchLineComment a, PatchLineComment b) {
                    int cmp = this.path(a).compareTo(this.path(b));
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = a.getSide() - b.getSide();
                    if (cmp != 0) {
                        return cmp;
                    }
                    return a.getLine() - b.getLine();
                }

                private String path(PatchLineComment c) {
                    return c.getKey().getParentKey().getFileName();
                }
            });
            CommentSender cm = this.commentSenderFactory.create(this.notify, this.change);
            cm.setFrom(this.authorId);
            cm.setPatchSet(this.patchSet, this.patchSetInfoFactory.get(this.change, this.patchSet));
            cm.setChangeMessage(this.message);
            cm.setPatchLineComments(this.comments);
            cm.send();
        }
        catch (Exception e) {
            log.error("Cannot email comments for " + this.patchSet.getId(), e);
        }
        finally {
            this.requestContext.setContext(null);
            if (this.db != null) {
                this.db.close();
                this.db = null;
            }
        }
    }

    public String toString() {
        return "send-email comments";
    }

    @Override
    public CurrentUser getCurrentUser() {
        return null;
    }

    @Override
    public Provider<ReviewDb> getReviewDbProvider() {
        return new Provider<ReviewDb>(){

            @Override
            public ReviewDb get() {
                if (EmailReviewComments.this.db == null) {
                    try {
                        EmailReviewComments.this.db = (ReviewDb)EmailReviewComments.this.schemaFactory.open();
                    }
                    catch (OrmException e) {
                        throw new ProvisionException("Cannot open ReviewDb", e);
                    }
                }
                return EmailReviewComments.this.db;
            }
        };
    }

    static interface Factory {
        public EmailReviewComments create(ReviewInput.NotifyHandling var1, Change var2, PatchSet var3, Account.Id var4, ChangeMessage var5, List<PatchLineComment> var6);
    }
}

