/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gerrit.common.data.PatchScript;
import com.google.gerrit.extensions.restapi.CacheControl;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.prettify.common.SparseFileContent;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountDiffPreference;
import com.google.gerrit.reviewdb.client.Patch;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.change.FileResource;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.change.Revisions;
import com.google.gerrit.server.git.LargeObjectException;
import com.google.gerrit.server.patch.PatchScriptFactory;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.ReplaceEdit;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.NamedOptionDef;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

public class GetDiff
implements RestReadView<FileResource> {
    private final ProjectCache projectCache;
    private final PatchScriptFactory.Factory patchScriptFactoryFactory;
    private final Revisions revisions;
    @Option(name="--base", metaVar="REVISION")
    String base;
    @Option(name="--ignore-whitespace")
    IgnoreWhitespace ignoreWhitespace = IgnoreWhitespace.NONE;
    @Option(name="--context", handler=ContextOptionHandler.class)
    short context = (short)10;
    @Option(name="--intraline")
    boolean intraline;

    @Inject
    GetDiff(ProjectCache projectCache, PatchScriptFactory.Factory patchScriptFactoryFactory, Revisions revisions) {
        this.projectCache = projectCache;
        this.patchScriptFactoryFactory = patchScriptFactoryFactory;
        this.revisions = revisions;
    }

    public Response<Result> apply(FileResource resource) throws ResourceConflictException, ResourceNotFoundException, OrmException {
        PatchSet.Id basePatchSet = null;
        if (this.base != null) {
            RevisionResource baseResource = this.revisions.parse(resource.getRevision().getChangeResource(), IdString.fromDecoded(this.base));
            basePatchSet = baseResource.getPatchSet().getId();
        }
        AccountDiffPreference prefs = new AccountDiffPreference(new Account.Id(0));
        prefs.setIgnoreWhitespace(this.ignoreWhitespace.whitespace);
        prefs.setContext(this.context);
        prefs.setIntralineDifference(this.intraline);
        try {
            PatchScriptFactory psf = this.patchScriptFactoryFactory.create(resource.getRevision().getControl(), resource.getPatchKey().getFileName(), basePatchSet, resource.getPatchKey().getParentKey(), prefs);
            psf.setLoadHistory(false);
            psf.setLoadComments(this.context != -1);
            PatchScript ps = psf.call();
            Content content = new Content(ps);
            block6: for (Edit edit : ps.getEdits()) {
                if (edit.getType() == Edit.Type.EMPTY) continue;
                content.addCommon(edit.getBeginA());
                Preconditions.checkState(content.nextA == edit.getBeginA(), "nextA = %d; want %d", content.nextA, edit.getBeginA());
                Preconditions.checkState(content.nextB == edit.getBeginB(), "nextB = %d; want %d", content.nextB, edit.getBeginB());
                switch (edit.getType()) {
                    case DELETE: 
                    case INSERT: 
                    case REPLACE: {
                        List<Edit> internalEdit = edit instanceof ReplaceEdit ? ((ReplaceEdit)edit).getInternalEdits() : null;
                        content.addDiff(edit.getEndA(), edit.getEndB(), internalEdit);
                        continue block6;
                    }
                }
                throw new IllegalStateException();
            }
            content.addCommon(ps.getA().size());
            ProjectState state = this.projectCache.get(resource.getRevision().getChange().getProject());
            Result result = new Result();
            if (ps.getDisplayMethodA() != PatchScript.DisplayMethod.NONE) {
                result.metaA = new FileMeta();
                result.metaA.name = Objects.firstNonNull(ps.getOldName(), ps.getNewName());
                this.setContentType(result.metaA, state, ps.getFileModeA(), ps.getMimeTypeA());
                result.metaA.lines = ps.getA().size();
            }
            if (ps.getDisplayMethodB() != PatchScript.DisplayMethod.NONE) {
                result.metaB = new FileMeta();
                result.metaB.name = ps.getNewName();
                this.setContentType(result.metaB, state, ps.getFileModeB(), ps.getMimeTypeB());
                result.metaB.lines = ps.getB().size();
            }
            if (this.intraline) {
                result.intralineStatus = ps.hasIntralineTimeout() ? IntraLineStatus.TIMEOUT : (ps.hasIntralineFailure() ? IntraLineStatus.FAILURE : IntraLineStatus.OK);
            }
            result.changeType = ps.getChangeType();
            if (ps.getPatchHeader().size() > 0) {
                result.diffHeader = ps.getPatchHeader();
            }
            result.content = content.lines;
            Response<Result> r = Response.ok(result);
            if (resource.isCacheable()) {
                r.caching(CacheControl.PRIVATE(7L, TimeUnit.DAYS));
            }
            return r;
        }
        catch (NoSuchChangeException e) {
            throw new ResourceNotFoundException(e.getMessage());
        }
        catch (LargeObjectException e) {
            throw new ResourceConflictException(e.getMessage());
        }
    }

    private void setContentType(FileMeta meta, ProjectState project, PatchScript.FileMode fileMode, String mimeType) {
        switch (fileMode) {
            case FILE: {
                if ("/COMMIT_MSG".equals(meta.name)) {
                    mimeType = "text/x-gerrit-commit-message";
                } else if (project != null) {
                    for (ProjectState p : project.tree()) {
                        String t = p.getConfig().getMimeTypes().getMimeType(meta.name);
                        if (t == null) continue;
                        mimeType = t;
                        break;
                    }
                }
                meta.contentType = mimeType;
                break;
            }
            case GITLINK: {
                meta.contentType = "x-git/gitlink";
                break;
            }
            case SYMLINK: {
                meta.contentType = "x-git/symlink";
                break;
            }
            default: {
                throw new IllegalStateException("file mode: " + (Object)((Object)fileMode));
            }
        }
    }

    public static class ContextOptionHandler
    extends OptionHandler<Short> {
        public ContextOptionHandler(CmdLineParser parser, OptionDef option, Setter<Short> setter) {
            super(parser, option, setter);
        }

        @Override
        public final int parseArguments(Parameters params) throws CmdLineException {
            short context;
            String value = params.getParameter(0);
            if ("all".equalsIgnoreCase(value)) {
                context = -1;
            } else {
                try {
                    context = Short.parseShort(value, 10);
                    if (context < 0) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException e) {
                    throw new CmdLineException(this.owner, String.format("\"%s\" is not a valid value for \"%s\"", value, ((NamedOptionDef)this.option).name()));
                }
            }
            this.setter.addValue(context);
            return 1;
        }

        @Override
        public final String getDefaultMetaVariable() {
            return "ALL|# LINES";
        }
    }

    static final class ContentEntry {
        List<String> ab;
        List<String> a;
        List<String> b;
        List<List<Integer>> editA;
        List<List<Integer>> editB;
        Boolean common;
        Integer skip;

        ContentEntry() {
        }
    }

    static enum IgnoreWhitespace {
        NONE(AccountDiffPreference.Whitespace.IGNORE_NONE),
        TRAILING(AccountDiffPreference.Whitespace.IGNORE_SPACE_AT_EOL),
        CHANGED(AccountDiffPreference.Whitespace.IGNORE_SPACE_CHANGE),
        ALL(AccountDiffPreference.Whitespace.IGNORE_ALL_SPACE);

        private final AccountDiffPreference.Whitespace whitespace;

        private IgnoreWhitespace(AccountDiffPreference.Whitespace whitespace) {
            this.whitespace = whitespace;
        }
    }

    private static class Content {
        final List<ContentEntry> lines;
        final SparseFileContent fileA;
        final SparseFileContent fileB;
        final boolean ignoreWS;
        int nextA;
        int nextB;

        Content(PatchScript ps) {
            this.lines = Lists.newArrayListWithExpectedSize(ps.getEdits().size() + 2);
            this.fileA = ps.getA();
            this.fileB = ps.getB();
            this.ignoreWS = ps.isIgnoreWhitespace();
        }

        void addCommon(int end) {
            if (this.nextA >= (end = Math.min(end, this.fileA.size()))) {
                return;
            }
            while (this.nextA < end) {
                if (!this.fileA.contains(this.nextA)) {
                    int endRegion = Math.min(end, this.nextA == 0 ? this.fileA.first() : this.fileA.next(this.nextA - 1));
                    int len = endRegion - this.nextA;
                    this.entry().skip = len;
                    this.nextA = endRegion;
                    this.nextB += len;
                    continue;
                }
                ContentEntry e = null;
                int i = this.nextA;
                while (i == this.nextA && i < end) {
                    if (this.ignoreWS && this.fileB.contains(this.nextB)) {
                        if (e == null || e.common == null) {
                            e = this.entry();
                            e.a = Lists.newArrayListWithCapacity(end - this.nextA);
                            e.b = Lists.newArrayListWithCapacity(end - this.nextA);
                            e.common = true;
                        }
                        e.a.add(this.fileA.get(this.nextA));
                        e.b.add(this.fileB.get(this.nextB));
                    } else {
                        if (e == null || e.common != null) {
                            e = this.entry();
                            e.ab = Lists.newArrayListWithCapacity(end - this.nextA);
                        }
                        e.ab.add(this.fileA.get(this.nextA));
                    }
                    i = this.fileA.next(i);
                    ++this.nextA;
                    ++this.nextB;
                }
            }
        }

        void addDiff(int endA, int endB, List<Edit> internalEdit) {
            int lenA = endA - this.nextA;
            int lenB = endB - this.nextB;
            Preconditions.checkState(lenA > 0 || lenB > 0);
            ContentEntry e = this.entry();
            if (lenA > 0) {
                e.a = Lists.newArrayListWithCapacity(lenA);
                while (this.nextA < endA) {
                    e.a.add(this.fileA.get(this.nextA));
                    ++this.nextA;
                }
            }
            if (lenB > 0) {
                e.b = Lists.newArrayListWithCapacity(lenB);
                while (this.nextB < endB) {
                    e.b.add(this.fileB.get(this.nextB));
                    ++this.nextB;
                }
            }
            if (internalEdit != null && !internalEdit.isEmpty()) {
                e.editA = Lists.newArrayListWithCapacity(internalEdit.size() * 2);
                e.editB = Lists.newArrayListWithCapacity(internalEdit.size() * 2);
                int lastA = 0;
                int lastB = 0;
                for (Edit edit : internalEdit) {
                    if (edit.getBeginA() != edit.getEndA()) {
                        e.editA.add(ImmutableList.of(Integer.valueOf(edit.getBeginA() - lastA), Integer.valueOf(edit.getEndA() - edit.getBeginA())));
                        lastA = edit.getEndA();
                    }
                    if (edit.getBeginB() == edit.getEndB()) continue;
                    e.editB.add(ImmutableList.of(Integer.valueOf(edit.getBeginB() - lastB), Integer.valueOf(edit.getEndB() - edit.getBeginB())));
                    lastB = edit.getEndB();
                }
            }
        }

        private ContentEntry entry() {
            ContentEntry e = new ContentEntry();
            this.lines.add(e);
            return e;
        }
    }

    static enum IntraLineStatus {
        OK,
        TIMEOUT,
        FAILURE;

    }

    static class FileMeta {
        String name;
        String contentType;
        Integer lines;

        FileMeta() {
        }
    }

    static class Result {
        FileMeta metaA;
        FileMeta metaB;
        IntraLineStatus intralineStatus;
        Patch.ChangeType changeType;
        List<String> diffHeader;
        List<ContentEntry> content;

        Result() {
        }
    }
}

