/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.index.ChangeIndexer;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;

@RequiresCapability(value="administrateServer")
@Singleton
public class Index
implements RestModifyView<ChangeResource, Input> {
    private final Provider<ReviewDb> db;
    private final ChangeIndexer indexer;

    @Inject
    Index(Provider<ReviewDb> db, ChangeIndexer indexer) {
        this.db = db;
        this.indexer = indexer;
    }

    public Response<?> apply(ChangeResource rsrc, Input input) throws IOException {
        this.indexer.index(this.db.get(), rsrc.getChange());
        return Response.none();
    }

    public static class Input {
    }
}

