/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.PatchLineCommentsUtil;
import com.google.gerrit.server.account.AccountInfo;
import com.google.gerrit.server.change.ListDrafts;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
class ListComments
extends ListDrafts {
    private final PatchLineCommentsUtil plcUtil;

    @Inject
    ListComments(Provider<ReviewDb> db, AccountInfo.Loader.Factory alf, PatchLineCommentsUtil plcUtil) {
        super(db, alf);
        this.plcUtil = plcUtil;
    }

    @Override
    protected boolean includeAuthorInfo() {
        return true;
    }

    @Override
    protected Iterable<PatchLineComment> listComments(RevisionResource rsrc) throws OrmException {
        ChangeNotes notes = rsrc.getNotes();
        return this.plcUtil.publishedByPatchSet((ReviewDb)this.db.get(), notes, rsrc.getPatchSet().getId());
    }
}

