/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.Sets;
import com.google.gerrit.reviewdb.client.Change;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Singleton;

@Singleton
class MergeabilityCheckQueue {
    private final Set<Change.Id> pending = Sets.newHashSet();
    private final Set<Change.Id> forcePending = Sets.newHashSet();

    MergeabilityCheckQueue() {
    }

    synchronized Set<Change> addAll(Collection<Change> changes, boolean force) {
        LinkedHashSet<Change> r = Sets.newLinkedHashSetWithExpectedSize(changes.size());
        for (Change c : changes) {
            if (!(force ? this.forcePending.add(c.getId()) : this.pending.add(c.getId()))) continue;
            r.add(c);
        }
        return r;
    }

    synchronized void updatingMergeabilityFlag(Change change, boolean force) {
        if (force) {
            this.forcePending.remove(change.getId());
        }
        this.pending.remove(change.getId());
    }
}

