/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.util.concurrent.CheckedFuture;
import com.google.gerrit.common.ChangeHooks;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.index.ChangeIndexer;
import com.google.gerrit.server.mail.PatchSetNotificationSender;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.patch.PatchSetInfoNotAvailableException;
import com.google.gwtorm.server.AtomicUpdate;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.lib.Config;

@Singleton
public class Publish
implements RestModifyView<RevisionResource, Input>,
UiAction<RevisionResource> {
    private final Provider<ReviewDb> dbProvider;
    private final ChangeUpdate.Factory updateFactory;
    private final PatchSetNotificationSender sender;
    private final ChangeHooks hooks;
    private final ChangeIndexer indexer;
    private final boolean allowDrafts;

    @Inject
    public Publish(Provider<ReviewDb> dbProvider, ChangeUpdate.Factory updateFactory, PatchSetNotificationSender sender, ChangeHooks hooks, ChangeIndexer indexer, @GerritServerConfig Config cfg) {
        this.dbProvider = dbProvider;
        this.updateFactory = updateFactory;
        this.sender = sender;
        this.hooks = hooks;
        this.indexer = indexer;
        this.allowDrafts = cfg.getBoolean("change", "allowDrafts", true);
    }

    public Response<?> apply(RevisionResource rsrc, Input input) throws AuthException, ResourceNotFoundException, ResourceConflictException, OrmException, IOException {
        if (!rsrc.getPatchSet().isDraft()) {
            throw new ResourceConflictException("Patch set is not a draft");
        }
        if (!rsrc.getControl().canPublish(this.dbProvider.get())) {
            throw new AuthException("Cannot publish this draft patch set");
        }
        if (!this.allowDrafts) {
            throw new ResourceConflictException("Draft workflow is disabled.");
        }
        PatchSet updatedPatchSet = this.updateDraftPatchSet(rsrc);
        Change updatedChange = this.updateDraftChange(rsrc);
        ChangeUpdate update = this.updateFactory.create(rsrc.getControl(), updatedChange.getLastUpdatedOn());
        try {
            if (!updatedPatchSet.isDraft() || updatedChange.getStatus() == Change.Status.NEW) {
                CheckedFuture<?, IOException> indexFuture = this.indexer.indexAsync(updatedChange.getId());
                this.sender.send(rsrc.getNotes(), update, rsrc.getChange().getStatus() == Change.Status.DRAFT, rsrc.getUser(), updatedChange, updatedPatchSet, rsrc.getControl().getLabelTypes());
                indexFuture.checkedGet();
                this.hooks.doDraftPublishedHook(updatedChange, updatedPatchSet, this.dbProvider.get());
            }
        }
        catch (PatchSetInfoNotAvailableException e) {
            throw new ResourceNotFoundException(e.getMessage());
        }
        return Response.none();
    }

    private Change updateDraftChange(RevisionResource rsrc) throws OrmException {
        return this.dbProvider.get().changes().atomicUpdate(rsrc.getChange().getId(), new AtomicUpdate<Change>(){

            @Override
            public Change update(Change change) {
                if (change.getStatus() == Change.Status.DRAFT) {
                    change.setStatus(Change.Status.NEW);
                    ChangeUtil.updated(change);
                }
                return change;
            }
        });
    }

    private PatchSet updateDraftPatchSet(RevisionResource rsrc) throws OrmException {
        return this.dbProvider.get().patchSets().atomicUpdate(rsrc.getPatchSet().getId(), new AtomicUpdate<PatchSet>(){

            @Override
            public PatchSet update(PatchSet patchset) {
                patchset.setDraft(false);
                return patchset;
            }
        });
    }

    @Override
    public UiAction.Description getDescription(RevisionResource rsrc) {
        try {
            return new UiAction.Description().setTitle(String.format("Publish revision %d", rsrc.getPatchSet().getPatchSetId())).setVisible(rsrc.getPatchSet().isDraft() && rsrc.getControl().canPublish(this.dbProvider.get()));
        }
        catch (OrmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static class CurrentRevision
    implements RestModifyView<ChangeResource, Input> {
        private final Provider<ReviewDb> dbProvider;
        private final Publish publish;

        @Inject
        CurrentRevision(Provider<ReviewDb> dbProvider, Publish publish) {
            this.dbProvider = dbProvider;
            this.publish = publish;
        }

        public Response<?> apply(ChangeResource rsrc, Input input) throws AuthException, ResourceConflictException, ResourceNotFoundException, IOException, OrmException {
            PatchSet ps = this.dbProvider.get().patchSets().get(rsrc.getChange().currentPatchSetId());
            if (ps == null) {
                throw new ResourceConflictException("current revision is missing");
            }
            if (!rsrc.getControl().isPatchVisible(ps, this.dbProvider.get())) {
                throw new AuthException("current revision not accessible");
            }
            return this.publish.apply(new RevisionResource(rsrc, ps), input);
        }
    }

    public static class Input {
    }
}

