/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.AccountPatchReview;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.change.FileResource;
import com.google.gwtorm.server.OrmDuplicateKeyException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Collections;

public class Reviewed {
    private static AccountPatchReview getExisting(ReviewDb db, FileResource resource) throws OrmException {
        AccountPatchReview.Key key = new AccountPatchReview.Key(resource.getPatchKey(), resource.getAccountId());
        return db.accountPatchReviews().get(key);
    }

    private Reviewed() {
    }

    @Singleton
    public static class DeleteReviewed
    implements RestModifyView<FileResource, Input> {
        private final Provider<ReviewDb> dbProvider;

        @Inject
        DeleteReviewed(Provider<ReviewDb> dbProvider) {
            this.dbProvider = dbProvider;
        }

        public Response<?> apply(FileResource resource, Input input) throws OrmException {
            ReviewDb db = this.dbProvider.get();
            AccountPatchReview apr = Reviewed.getExisting(db, resource);
            if (apr != null) {
                db.accountPatchReviews().delete(Collections.singleton(apr));
            }
            return Response.none();
        }
    }

    @Singleton
    public static class PutReviewed
    implements RestModifyView<FileResource, Input> {
        private final Provider<ReviewDb> dbProvider;

        @Inject
        PutReviewed(Provider<ReviewDb> dbProvider) {
            this.dbProvider = dbProvider;
        }

        public Response<String> apply(FileResource resource, Input input) throws OrmException {
            ReviewDb db = this.dbProvider.get();
            AccountPatchReview apr = Reviewed.getExisting(db, resource);
            if (apr == null) {
                try {
                    db.accountPatchReviews().insert(Collections.singleton(new AccountPatchReview(resource.getPatchKey(), resource.getAccountId())));
                }
                catch (OrmDuplicateKeyException e) {
                    return Response.ok("");
                }
                return Response.created("");
            }
            return Response.ok("");
        }
    }

    public static class Input {
    }
}

