/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountExternalId;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountControl;
import com.google.gerrit.server.account.AccountInfo;
import com.google.gerrit.server.account.AccountVisibility;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupMembers;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.PostReviewers;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.group.GroupJson;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.Config;
import org.kohsuke.args4j.Option;

public class SuggestReviewers
implements RestReadView<ChangeResource> {
    private static final String MAX_SUFFIX = "\u9fa5";
    private static final int MAX = 10;
    private final AccountInfo.Loader.Factory accountLoaderFactory;
    private final AccountControl.Factory accountControlFactory;
    private final GroupMembers.Factory groupMembersFactory;
    private final AccountCache accountCache;
    private final Provider<ReviewDb> dbProvider;
    private final Provider<CurrentUser> currentUser;
    private final IdentifiedUser.GenericFactory identifiedUserFactory;
    private final GroupBackend groupBackend;
    private final boolean suggestAccounts;
    private final int suggestFrom;
    private final int maxAllowed;
    private int limit;
    private String query;

    @Option(name="--limit", aliases={"-n"}, metaVar="CNT", usage="maximum number of reviewers to list")
    public void setLimit(int l) {
        this.limit = l <= 0 ? 10 : Math.min(l, 10);
    }

    @Option(name="--query", aliases={"-q"}, metaVar="QUERY", usage="match reviewers query")
    public void setQuery(String q) {
        this.query = q;
    }

    @Inject
    SuggestReviewers(AccountVisibility av, AccountInfo.Loader.Factory accountLoaderFactory, AccountControl.Factory accountControlFactory, AccountCache accountCache, GroupMembers.Factory groupMembersFactory, IdentifiedUser.GenericFactory identifiedUserFactory, Provider<CurrentUser> currentUser, Provider<ReviewDb> dbProvider, @GerritServerConfig Config cfg, GroupBackend groupBackend) {
        this.accountLoaderFactory = accountLoaderFactory;
        this.accountControlFactory = accountControlFactory;
        this.accountCache = accountCache;
        this.groupMembersFactory = groupMembersFactory;
        this.dbProvider = dbProvider;
        this.identifiedUserFactory = identifiedUserFactory;
        this.currentUser = currentUser;
        this.groupBackend = groupBackend;
        String suggest = cfg.getString("suggest", null, "accounts");
        this.suggestAccounts = "OFF".equalsIgnoreCase(suggest) || "false".equalsIgnoreCase(suggest) ? false : av != AccountVisibility.NONE;
        this.suggestFrom = cfg.getInt("suggest", null, "from", 0);
        this.maxAllowed = cfg.getInt("addreviewer", "maxAllowed", 20);
    }

    public List<SuggestedReviewerInfo> apply(ChangeResource rsrc) throws BadRequestException, OrmException, IOException {
        if (Strings.isNullOrEmpty(this.query)) {
            throw new BadRequestException("missing query field");
        }
        if (!this.suggestAccounts || this.query.length() < this.suggestFrom) {
            return Collections.emptyList();
        }
        VisibilityControl visibilityControl = this.getVisibility(rsrc);
        List<AccountInfo> suggestedAccounts = this.suggestAccount(visibilityControl);
        this.accountLoaderFactory.create(true).fill(suggestedAccounts);
        ArrayList<SuggestedReviewerInfo> reviewer = Lists.newArrayList();
        for (AccountInfo a : suggestedAccounts) {
            reviewer.add(new SuggestedReviewerInfo(a));
        }
        Project p = rsrc.getControl().getProject();
        for (GroupReference g : this.suggestAccountGroup(rsrc.getControl().getProjectControl())) {
            if (!this.suggestGroupAsReviewer(p, g, visibilityControl)) continue;
            GroupJson.GroupBaseInfo info = new GroupJson.GroupBaseInfo();
            info.id = Url.encode(g.getUUID().get());
            info.name = g.getName();
            reviewer.add(new SuggestedReviewerInfo(info));
        }
        Collections.sort(reviewer);
        if (reviewer.size() <= this.limit) {
            return reviewer;
        }
        return reviewer.subList(0, this.limit);
    }

    private VisibilityControl getVisibility(final ChangeResource rsrc) {
        if (rsrc.getControl().getRefControl().isVisibleByRegisteredUsers()) {
            return new VisibilityControl(){

                @Override
                public boolean isVisibleTo(Account account) throws OrmException {
                    return true;
                }
            };
        }
        return new VisibilityControl(){

            @Override
            public boolean isVisibleTo(Account account) throws OrmException {
                IdentifiedUser who = SuggestReviewers.this.identifiedUserFactory.create(SuggestReviewers.this.dbProvider, account.getId());
                return rsrc.getControl().forUser(who).isRefVisible();
            }
        };
    }

    private List<GroupReference> suggestAccountGroup(ProjectControl ctl) {
        return Lists.newArrayList(Iterables.limit(this.groupBackend.suggest(this.query, ctl), this.limit));
    }

    private List<AccountInfo> suggestAccount(VisibilityControl visibilityControl) throws OrmException {
        String a = this.query;
        String b = a + MAX_SUFFIX;
        LinkedHashMap<Account.Id, AccountInfo> r = Maps.newLinkedHashMap();
        for (Account p : this.dbProvider.get().accounts().suggestByFullName(a, b, this.limit)) {
            this.addSuggestion(r, p, new AccountInfo(p.getId()), visibilityControl);
        }
        if (r.size() < this.limit) {
            for (Account p : this.dbProvider.get().accounts().suggestByPreferredEmail(a, b, this.limit - r.size())) {
                this.addSuggestion(r, p, new AccountInfo(p.getId()), visibilityControl);
            }
        }
        if (r.size() < this.limit) {
            for (AccountExternalId e : this.dbProvider.get().accountExternalIds().suggestByEmailAddress(a, b, this.limit - r.size())) {
                if (r.containsKey(e.getAccountId())) continue;
                Account p = this.accountCache.get(e.getAccountId()).getAccount();
                AccountInfo info = new AccountInfo(p.getId());
                this.addSuggestion(r, p, info, visibilityControl);
            }
        }
        return Lists.newArrayList(r.values());
    }

    private void addSuggestion(Map<Account.Id, AccountInfo> map, Account account, AccountInfo info, VisibilityControl visibilityControl) throws OrmException {
        if (!map.containsKey(account.getId()) && account.isActive() && visibilityControl.isVisibleTo(account) && this.accountControlFactory.get().canSee(account)) {
            map.put(account.getId(), info);
        }
    }

    private boolean suggestGroupAsReviewer(Project project, GroupReference group, VisibilityControl visibilityControl) throws OrmException, IOException {
        if (!PostReviewers.isLegalReviewerGroup(group.getUUID())) {
            return false;
        }
        try {
            Set<Account> members = this.groupMembersFactory.create(this.currentUser.get()).listAccounts(group.getUUID(), project.getNameKey());
            if (members.isEmpty()) {
                return false;
            }
            if (this.maxAllowed > 0 && members.size() > this.maxAllowed) {
                return false;
            }
            for (Account account : members) {
                if (!visibilityControl.isVisibleTo(account)) continue;
                return true;
            }
        }
        catch (NoSuchGroupException e) {
            return false;
        }
        catch (NoSuchProjectException e) {
            return false;
        }
        return false;
    }

    public static class SuggestedReviewerInfo
    implements Comparable<SuggestedReviewerInfo> {
        public AccountInfo account;
        public GroupJson.GroupBaseInfo group;

        SuggestedReviewerInfo(AccountInfo a) {
            this.account = a;
        }

        SuggestedReviewerInfo(GroupJson.GroupBaseInfo g) {
            this.group = g;
        }

        @Override
        public int compareTo(SuggestedReviewerInfo o) {
            return this.getSortValue().compareTo(o.getSortValue());
        }

        private String getSortValue() {
            return this.account != null ? Objects.firstNonNull(this.account.email, Strings.nullToEmpty(this.account.name)) : Strings.nullToEmpty(this.group.name);
        }
    }

    private static interface VisibilityControl {
        public boolean isVisibleTo(Account var1) throws OrmException;
    }
}

