/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.common.cache.Cache;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.server.config.ConfigResource;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;

public class CacheResource
extends ConfigResource {
    public static final TypeLiteral<RestView<CacheResource>> CACHE_KIND = new TypeLiteral<RestView<CacheResource>>(){};
    private final String name;
    private final Provider<Cache<?, ?>> cacheProvider;

    public CacheResource(String pluginName, String cacheName, Provider<Cache<?, ?>> cacheProvider) {
        this.name = CacheResource.cacheNameOf(pluginName, cacheName);
        this.cacheProvider = cacheProvider;
    }

    public CacheResource(String pluginName, String cacheName, final Cache<?, ?> cache) {
        this(pluginName, cacheName, new Provider<Cache<?, ?>>(){

            @Override
            public Cache<?, ?> get() {
                return cache;
            }
        });
    }

    public String getName() {
        return this.name;
    }

    public Cache<?, ?> getCache() {
        return this.cacheProvider.get();
    }

    public static String cacheNameOf(String plugin, String name) {
        if ("gerrit".equals(plugin)) {
            return name;
        }
        return plugin + "-" + name;
    }
}

