/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.config.CacheResource;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@RequiresCapability(value="flushCaches")
@Singleton
public class FlushCache
implements RestModifyView<CacheResource, Input> {
    public static final String WEB_SESSIONS = "web_sessions";
    private final Provider<CurrentUser> self;

    @Inject
    public FlushCache(Provider<CurrentUser> self) {
        this.self = self;
    }

    public Response<String> apply(CacheResource rsrc, Input input) throws AuthException {
        if (WEB_SESSIONS.equals(rsrc.getName()) && !this.self.get().getCapabilities().canAdministrateServer()) {
            throw new AuthException(String.format("only site administrators can flush %s", WEB_SESSIONS));
        }
        rsrc.getCache().invalidateAll();
        return Response.ok("");
    }

    public static class Input {
    }
}

