/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.server.config.SitePaths;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GerritServerConfigProvider
implements Provider<Config> {
    private static final Logger log = LoggerFactory.getLogger(GerritServerConfigProvider.class);
    private final SitePaths site;

    @Inject
    GerritServerConfigProvider(SitePaths site) {
        this.site = site;
    }

    @Override
    public Config get() {
        FileBasedConfig cfg = new FileBasedConfig(this.site.gerrit_config, FS.DETECTED);
        if (!cfg.getFile().exists()) {
            log.info("No " + this.site.gerrit_config.getAbsolutePath() + "; assuming defaults");
            return cfg;
        }
        try {
            cfg.load();
        }
        catch (IOException e) {
            throw new ProvisionException(e.getMessage(), e);
        }
        catch (ConfigInvalidException e) {
            throw new ProvisionException(e.getMessage(), e);
        }
        if (this.site.secure_config.exists()) {
            cfg = new FileBasedConfig(cfg, this.site.secure_config, FS.DETECTED);
            try {
                cfg.load();
            }
            catch (IOException e) {
                throw new ProvisionException(e.getMessage(), e);
            }
            catch (ConfigInvalidException e) {
                throw new ProvisionException(e.getMessage(), e);
            }
        }
        return cfg;
    }
}

