/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.config.ConfigResource;
import com.google.gerrit.server.config.SitePath;
import com.google.gerrit.server.git.WorkQueue;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.internal.storage.file.WindowCacheStatAccessor;
import org.kohsuke.args4j.Option;

@RequiresCapability(value="administrateServer")
public class GetSummary
implements RestReadView<ConfigResource> {
    private final WorkQueue workQueue;
    private final File sitePath;
    @Option(name="--gc", usage="perform Java GC before retrieving memory stats")
    private boolean gc;
    @Option(name="--jvm", usage="include details about the JVM")
    private boolean jvm;

    public GetSummary setGc(boolean gc) {
        this.gc = gc;
        return this;
    }

    public GetSummary setJvm(boolean jvm) {
        this.jvm = jvm;
        return this;
    }

    @Inject
    public GetSummary(WorkQueue workQueue, @SitePath File sitePath) {
        this.workQueue = workQueue;
        this.sitePath = sitePath;
    }

    public SummaryInfo apply(ConfigResource rsrc) {
        if (this.gc) {
            System.gc();
            System.runFinalization();
            System.gc();
        }
        SummaryInfo summary = new SummaryInfo();
        summary.taskSummary = this.getTaskSummary();
        summary.memSummary = this.getMemSummary();
        summary.threadSummary = this.getThreadSummary();
        if (this.jvm) {
            summary.jvmSummary = this.getJvmSummary();
        }
        return summary;
    }

    private TaskSummaryInfo getTaskSummary() {
        List<WorkQueue.Task<?>> pending = this.workQueue.getTasks();
        int tasksTotal = pending.size();
        int tasksRunning = 0;
        int tasksReady = 0;
        int tasksSleeping = 0;
        for (WorkQueue.Task task : pending) {
            switch (task.getState()) {
                case RUNNING: {
                    ++tasksRunning;
                    break;
                }
                case READY: {
                    ++tasksReady;
                    break;
                }
                case SLEEPING: {
                    ++tasksSleeping;
                    break;
                }
            }
        }
        TaskSummaryInfo taskSummary = new TaskSummaryInfo();
        taskSummary.total = GetSummary.toInteger(tasksTotal);
        taskSummary.running = GetSummary.toInteger(tasksRunning);
        taskSummary.ready = GetSummary.toInteger(tasksReady);
        taskSummary.sleeping = GetSummary.toInteger(tasksSleeping);
        return taskSummary;
    }

    private MemSummaryInfo getMemSummary() {
        Runtime r = Runtime.getRuntime();
        long mMax = r.maxMemory();
        long mFree = r.freeMemory();
        long mTotal = r.totalMemory();
        long mInuse = mTotal - mFree;
        int jgitOpen = WindowCacheStatAccessor.getOpenFiles();
        long jgitBytes = WindowCacheStatAccessor.getOpenBytes();
        MemSummaryInfo memSummaryInfo = new MemSummaryInfo();
        memSummaryInfo.total = GetSummary.bytes(mTotal);
        memSummaryInfo.used = GetSummary.bytes(mInuse - jgitBytes);
        memSummaryInfo.free = GetSummary.bytes(mFree);
        memSummaryInfo.buffers = GetSummary.bytes(jgitBytes);
        memSummaryInfo.max = GetSummary.bytes(mMax);
        memSummaryInfo.openFiles = GetSummary.toInteger(jgitOpen);
        return memSummaryInfo;
    }

    private ThreadSummaryInfo getThreadSummary() {
        Runtime r = Runtime.getRuntime();
        ThreadSummaryInfo threadInfo = new ThreadSummaryInfo();
        threadInfo.cpus = r.availableProcessors();
        threadInfo.threads = GetSummary.toInteger(ManagementFactory.getThreadMXBean().getThreadCount());
        List<String> prefixes = Arrays.asList("HTTP", "IntraLineDiff", "ReceiveCommits", "SSH git-receive-pack", "SSH git-upload-pack", "SSH-Interactive-Worker", "SSH-Stream-Worker", "SshCommandStart");
        String other = "Other";
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        threadInfo.counts = new HashMap<String, Map<Thread.State, Integer>>();
        for (long id : threadMXBean.getAllThreadIds()) {
            Integer c;
            Map<Thread.State, Integer> counts;
            ThreadInfo info = threadMXBean.getThreadInfo(id);
            if (info == null) continue;
            String name = info.getThreadName();
            Thread.State state = info.getThreadState();
            String group = other;
            for (String p : prefixes) {
                if (!name.startsWith(p)) continue;
                group = p;
                break;
            }
            if ((counts = threadInfo.counts.get(group)) == null) {
                counts = new HashMap<Thread.State, Integer>();
                threadInfo.counts.put(group, counts);
            }
            counts.put(state, (c = counts.get((Object)state)) != null ? c + 1 : 1);
        }
        return threadInfo;
    }

    private JvmSummaryInfo getJvmSummary() {
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        JvmSummaryInfo jvmSummary = new JvmSummaryInfo();
        jvmSummary.vmVendor = runtimeBean.getVmVendor();
        jvmSummary.vmName = runtimeBean.getVmName();
        jvmSummary.vmVersion = runtimeBean.getVmVersion();
        jvmSummary.osName = osBean.getName();
        jvmSummary.osVersion = osBean.getVersion();
        jvmSummary.osArch = osBean.getArch();
        jvmSummary.user = System.getProperty("user.name");
        try {
            jvmSummary.host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        jvmSummary.currentWorkingDirectory = GetSummary.path(new File(".").getAbsoluteFile().getParentFile());
        jvmSummary.site = GetSummary.path(this.sitePath);
        return jvmSummary;
    }

    private static Integer toInteger(int i) {
        return i != 0 ? Integer.valueOf(i) : null;
    }

    private static String bytes(double value) {
        value /= 1024.0;
        String suffix = "k";
        if (value > 1024.0) {
            value /= 1024.0;
            suffix = "m";
        }
        if (value > 1024.0) {
            value /= 1024.0;
            suffix = "g";
        }
        return String.format("%1$6.2f%2$s", value, suffix).trim();
    }

    private static String path(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException err) {
            return file.getAbsolutePath();
        }
    }

    public static class JvmSummaryInfo {
        public String vmVendor;
        public String vmName;
        public String vmVersion;
        public String osName;
        public String osVersion;
        public String osArch;
        public String user;
        public String host;
        public String currentWorkingDirectory;
        public String site;
    }

    public static class ThreadSummaryInfo {
        public Integer cpus;
        public Integer threads;
        public Map<String, Map<Thread.State, Integer>> counts;
    }

    public static class MemSummaryInfo {
        public String total;
        public String used;
        public String free;
        public String buffers;
        public String max;
        public Integer openFiles;
    }

    public static class TaskSummaryInfo {
        public Integer total;
        public Integer running;
        public Integer ready;
        public Integer sleeping;
    }

    public static class SummaryInfo {
        public TaskSummaryInfo taskSummary;
        public MemSummaryInfo memSummary;
        public ThreadSummaryInfo threadSummary;
        public JvmSummaryInfo jvmSummary;
    }
}

