/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.common.collect.ImmutableSet;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupBackends;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.util.RequestContext;
import com.google.gerrit.server.util.ServerRequestContext;
import com.google.gerrit.server.util.ThreadLocalRequestContext;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Set;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GroupSetProvider
implements Provider<Set<AccountGroup.UUID>> {
    private static final Logger log = LoggerFactory.getLogger(GroupSetProvider.class);
    protected Set<AccountGroup.UUID> groupIds;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject
    protected GroupSetProvider(GroupBackend groupBackend, @GerritServerConfig Config config, ThreadLocalRequestContext threadContext, ServerRequestContext serverCtx, String section, String subsection, String name) {
        RequestContext ctx = threadContext.setContext(serverCtx);
        try {
            String[] groupNames = config.getStringList(section, subsection, name);
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (String n : groupNames) {
                GroupReference g = GroupBackends.findBestSuggestion(groupBackend, n);
                if (g == null) {
                    log.warn("Group \"{}\" not in database, skipping.", (Object)n);
                    continue;
                }
                builder.add(g.getUUID());
            }
            this.groupIds = builder.build();
        }
        finally {
            threadContext.setContext(ctx);
        }
    }

    @Override
    public Set<AccountGroup.UUID> get() {
        return this.groupIds;
    }
}

