/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.common.cache.Cache;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.server.config.CacheResource;
import com.google.gerrit.server.config.ConfigResource;
import com.google.gerrit.server.config.FlushCache;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;

@RequiresCapability(value="flushCaches")
@Singleton
public class PostCaches
implements RestModifyView<ConfigResource, Input> {
    private final DynamicMap<Cache<?, ?>> cacheMap;
    private final FlushCache flushCache;

    @Inject
    public PostCaches(DynamicMap<Cache<?, ?>> cacheMap, FlushCache flushCache) {
        this.cacheMap = cacheMap;
        this.flushCache = flushCache;
    }

    @Override
    public Object apply(ConfigResource rsrc, Input input) throws AuthException, ResourceNotFoundException, BadRequestException, UnprocessableEntityException {
        if (input == null || input.operation == null) {
            throw new BadRequestException("operation must be specified");
        }
        switch (input.operation) {
            case FLUSH_ALL: {
                if (input.caches != null) {
                    throw new BadRequestException("specifying caches is not allowed for operation 'FLUSH_ALL'");
                }
                this.flushAll();
                return Response.ok("");
            }
            case FLUSH: {
                if (input.caches == null || input.caches.isEmpty()) {
                    throw new BadRequestException("caches must be specified for operation 'FLUSH'");
                }
                this.flush(input.caches);
                return Response.ok("");
            }
        }
        throw new BadRequestException("unsupported operation: " + (Object)((Object)input.operation));
    }

    private void flushAll() throws AuthException {
        for (DynamicMap.Entry<Cache<?, ?>> entry : this.cacheMap) {
            CacheResource cacheResource = new CacheResource(entry.getPluginName(), entry.getExportName(), entry.getProvider());
            if ("web_sessions".equals(cacheResource.getName())) continue;
            this.flushCache.apply(cacheResource, null);
        }
    }

    private void flush(List<String> cacheNames) throws UnprocessableEntityException, AuthException {
        ArrayList<CacheResource> cacheResources = new ArrayList<CacheResource>(cacheNames.size());
        for (String n : cacheNames) {
            Cache<?, ?> cache;
            String pluginName = "gerrit";
            String cacheName = n;
            int i = cacheName.lastIndexOf(45);
            if (i != -1) {
                pluginName = cacheName.substring(0, i);
                String string = cacheName = cacheName.length() > i + 1 ? cacheName.substring(i + 1) : "";
            }
            if ((cache = this.cacheMap.get(pluginName, cacheName)) != null) {
                cacheResources.add(new CacheResource(pluginName, cacheName, cache));
                continue;
            }
            throw new UnprocessableEntityException(String.format("cache %s not found", n));
        }
        for (CacheResource rsrc : cacheResources) {
            this.flushCache.apply(rsrc, null);
        }
    }

    public static enum Operation {
        FLUSH_ALL,
        FLUSH;

    }

    public static class Input {
        public Operation operation;
        public List<String> caches;

        public Input() {
        }

        public Input(Operation op) {
            this(op, null);
        }

        public Input(Operation op, List<String> c) {
            this.operation = op;
            this.caches = c;
        }
    }
}

