/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.server.config.SitePath;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

@Singleton
public final class SitePaths {
    public static final String CSS_FILENAME = "GerritSite.css";
    public static final String HEADER_FILENAME = "GerritSiteHeader.html";
    public static final String FOOTER_FILENAME = "GerritSiteFooter.html";
    public final File site_path;
    public final File bin_dir;
    public final File etc_dir;
    public final File lib_dir;
    public final File tmp_dir;
    public final File logs_dir;
    public final File plugins_dir;
    public final File data_dir;
    public final File mail_dir;
    public final File hooks_dir;
    public final File static_dir;
    public final File themes_dir;
    public final File index_dir;
    public final File gerrit_sh;
    public final File gerrit_war;
    public final File gerrit_config;
    public final File secure_config;
    public final File contact_information_pub;
    public final File ssl_keystore;
    public final File ssh_key;
    public final File ssh_rsa;
    public final File ssh_dsa;
    public final File peer_keys;
    public final File site_css;
    public final File site_header;
    public final File site_footer;
    public final File site_gitweb;
    public final boolean isNew;

    /*
     * Enabled aggressive block sorting
     */
    @Inject
    public SitePaths(@SitePath File sitePath) throws FileNotFoundException {
        this.site_path = sitePath;
        this.bin_dir = new File(this.site_path, "bin");
        this.etc_dir = new File(this.site_path, "etc");
        this.lib_dir = new File(this.site_path, "lib");
        this.tmp_dir = new File(this.site_path, "tmp");
        this.plugins_dir = new File(this.site_path, "plugins");
        this.data_dir = new File(this.site_path, "data");
        this.logs_dir = new File(this.site_path, "logs");
        this.mail_dir = new File(this.etc_dir, "mail");
        this.hooks_dir = new File(this.site_path, "hooks");
        this.static_dir = new File(this.site_path, "static");
        this.themes_dir = new File(this.site_path, "themes");
        this.index_dir = new File(this.site_path, "index");
        this.gerrit_sh = new File(this.bin_dir, "gerrit.sh");
        this.gerrit_war = new File(this.bin_dir, "gerrit.war");
        this.gerrit_config = new File(this.etc_dir, "gerrit.config");
        this.secure_config = new File(this.etc_dir, "secure.config");
        this.contact_information_pub = new File(this.etc_dir, "contact_information.pub");
        this.ssl_keystore = new File(this.etc_dir, "keystore");
        this.ssh_key = new File(this.etc_dir, "ssh_host_key");
        this.ssh_rsa = new File(this.etc_dir, "ssh_host_rsa_key");
        this.ssh_dsa = new File(this.etc_dir, "ssh_host_dsa_key");
        this.peer_keys = new File(this.etc_dir, "peer_keys");
        this.site_css = new File(this.etc_dir, CSS_FILENAME);
        this.site_header = new File(this.etc_dir, HEADER_FILENAME);
        this.site_footer = new File(this.etc_dir, FOOTER_FILENAME);
        this.site_gitweb = new File(this.etc_dir, "gitweb_config.perl");
        if (!this.site_path.exists()) {
            this.isNew = true;
            return;
        }
        String[] contents = this.site_path.list();
        if (contents == null) {
            if (!this.site_path.isDirectory()) throw new FileNotFoundException("Not a directory: " + this.site_path);
            throw new FileNotFoundException("Cannot access " + this.site_path);
        }
        this.isNew = contents.length == 0;
    }

    public File resolve(String path) {
        if (path != null && !path.isEmpty()) {
            File loc = new File(path);
            if (!loc.isAbsolute()) {
                loc = new File(this.site_path, path);
            }
            try {
                return loc.getCanonicalFile();
            }
            catch (IOException e) {
                return loc.getAbsoluteFile();
            }
        }
        return null;
    }
}

