/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.TrackingFooter;
import com.google.gerrit.server.config.TrackingFooters;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TrackingFootersProvider
implements Provider<TrackingFooters> {
    private static String TRACKING_ID_TAG = "trackingid";
    private static String FOOTER_TAG = "footer";
    private static String SYSTEM_TAG = "system";
    private static String REGEX_TAG = "match";
    private final List<TrackingFooter> trackingFooters = new ArrayList<TrackingFooter>();
    private static final Logger log = LoggerFactory.getLogger(TrackingFootersProvider.class);

    @Inject
    TrackingFootersProvider(@GerritServerConfig Config cfg) {
        for (String name : cfg.getSubsections(TRACKING_ID_TAG)) {
            String system;
            boolean configValid = true;
            String footer = cfg.getString(TRACKING_ID_TAG, name, FOOTER_TAG);
            if (footer == null || footer.isEmpty()) {
                configValid = false;
                log.error("Missing " + TRACKING_ID_TAG + "." + name + "." + FOOTER_TAG + " in gerrit.config");
            }
            if ((system = cfg.getString(TRACKING_ID_TAG, name, SYSTEM_TAG)) == null || system.isEmpty()) {
                configValid = false;
                log.error("Missing " + TRACKING_ID_TAG + "." + name + "." + SYSTEM_TAG + " in gerrit.config");
            } else if (system.length() > 10) {
                configValid = false;
                log.error("String to long \"" + system + "\" in gerrit.config " + TRACKING_ID_TAG + "." + name + "." + SYSTEM_TAG + " (max " + 10 + " char)");
            }
            String match = cfg.getString(TRACKING_ID_TAG, name, REGEX_TAG);
            if (match == null || match.isEmpty()) {
                configValid = false;
                log.error("Missing " + TRACKING_ID_TAG + "." + name + "." + REGEX_TAG + " in gerrit.config");
            }
            if (!configValid) continue;
            try {
                this.trackingFooters.add(new TrackingFooter(footer, match, system));
            }
            catch (PatternSyntaxException e) {
                log.error("Invalid pattern \"" + match + "\" in gerrit.config " + TRACKING_ID_TAG + "." + name + "." + REGEX_TAG + ": " + e.getMessage());
            }
        }
    }

    @Override
    public TrackingFooters get() {
        return new TrackingFooters(this.trackingFooters);
    }
}

