/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.contact;

import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.contact.ContactStore;
import com.google.gerrit.server.contact.ContactStoreConnection;
import com.google.gerrit.server.contact.EncryptedContactStore;
import com.google.gerrit.server.contact.NoContactStore;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.ProvisionException;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.util.StringUtils;

public class ContactStoreProvider
implements com.google.inject.Provider<ContactStore> {
    private final Config config;
    private final SitePaths site;
    private final SchemaFactory<ReviewDb> schema;
    private final ContactStoreConnection.Factory connFactory;

    @Inject
    ContactStoreProvider(@GerritServerConfig Config config, SitePaths site, SchemaFactory<ReviewDb> schema, ContactStoreConnection.Factory connFactory) {
        this.config = config;
        this.site = site;
        this.schema = schema;
        this.connFactory = connFactory;
    }

    @Override
    public ContactStore get() {
        URL storeUrl;
        String url = this.config.getString("contactstore", null, "url");
        if (StringUtils.isEmptyOrNull(url)) {
            return new NoContactStore();
        }
        if (!ContactStoreProvider.havePGP()) {
            throw new ProvisionException("BouncyCastle PGP not installed;  needed to encrypt contact information");
        }
        try {
            storeUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new ProvisionException("Invalid contactstore.url: " + url, e);
        }
        String storeAPPSEC = this.config.getString("contactstore", null, "appsec");
        File pubkey = this.site.contact_information_pub;
        if (!pubkey.exists()) {
            throw new ProvisionException("PGP public key file \"" + pubkey.getAbsolutePath() + "\" not found");
        }
        return new EncryptedContactStore(storeUrl, storeAPPSEC, pubkey, this.schema, this.connFactory);
    }

    private static boolean havePGP() {
        try {
            Class.forName(PGPPublicKey.class.getName());
            ContactStoreProvider.addBouncyCastleProvider();
            return true;
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoClassDefFoundError | NoSuchMethodException | SecurityException | InvocationTargetException noBouncyCastle) {
            return false;
        }
    }

    private static void addBouncyCastleProvider() throws ClassNotFoundException, SecurityException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Class.forName(BouncyCastleProvider.class.getName());
        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
        Security.addProvider((Provider)constructor.newInstance(new Object[0]));
    }
}

