/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.contact;

import com.google.gerrit.server.contact.ContactStoreConnection;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.jgit.util.IO;

public class HttpContactStoreConnection
implements ContactStoreConnection {
    private final HttpURLConnection conn;

    public static Module module() {
        return new AbstractModule(){

            @Override
            protected void configure() {
                this.install(new FactoryModuleBuilder().implement(ContactStoreConnection.class, HttpContactStoreConnection.class).build(ContactStoreConnection.Factory.class));
            }
        };
    }

    @Inject
    HttpContactStoreConnection(@Assisted URL url) throws IOException {
        URLConnection urlConn = url.openConnection();
        if (!(urlConn instanceof HttpURLConnection)) {
            throw new IllegalArgumentException("Non-HTTP URL not supported: " + urlConn);
        }
        this.conn = (HttpURLConnection)urlConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(byte[] body) throws IOException {
        this.conn.setRequestMethod("POST");
        this.conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        this.conn.setDoOutput(true);
        this.conn.setFixedLengthStreamingMode(body.length);
        try (OutputStream out = this.conn.getOutputStream();){
            out.write(body);
        }
        if (this.conn.getResponseCode() != 200) {
            throw new IOException("Connection failed: " + this.conn.getResponseCode());
        }
        byte[] dst = new byte[2];
        try (InputStream in = this.conn.getInputStream();){
            IO.readFully(in, dst, 0, 2);
        }
        if (dst[0] != 79 || dst[1] != 75) {
            throw new IOException("Store failed: " + dst[0] + dst[1]);
        }
    }
}

