/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.documentation;

import com.google.common.base.Strings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.pegdown.LinkRenderer;
import org.pegdown.PegDownProcessor;
import org.pegdown.ToHtmlSerializer;
import org.pegdown.ast.HeaderNode;
import org.pegdown.ast.Node;
import org.pegdown.ast.RootNode;
import org.pegdown.ast.TextNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkdownFormatter {
    private static final Logger log;
    private static final String css;

    private static String readCSS() {
        if (css != null) {
            return css;
        }
        try {
            return MarkdownFormatter.readPegdownCss(new AtomicBoolean());
        }
        catch (IOException err) {
            log.warn("Cannot load pegdown.css", err);
            return "";
        }
    }

    public byte[] markdownToDocHtml(String md, String charEnc) throws UnsupportedEncodingException {
        RootNode root = this.parseMarkdown(md);
        String title = this.findTitle(root);
        StringBuilder html = new StringBuilder();
        html.append("<html>");
        html.append("<head>");
        if (!Strings.isNullOrEmpty(title)) {
            html.append("<title>").append(title).append("</title>");
        }
        html.append("<style type=\"text/css\">\n").append(MarkdownFormatter.readCSS()).append("\n</style>");
        html.append("</head>");
        html.append("<body>\n");
        html.append(new ToHtmlSerializer(new LinkRenderer()).toHtml(root));
        html.append("\n</body></html>");
        return html.toString().getBytes(charEnc);
    }

    public String extractTitleFromMarkdown(byte[] data, String charEnc) {
        String md = RawParseUtils.decode(Charset.forName(charEnc), data);
        return this.findTitle(this.parseMarkdown(md));
    }

    private String findTitle(Node root) {
        HeaderNode h;
        if (root instanceof HeaderNode && (h = (HeaderNode)root).getLevel() == 1 && h.getChildren() != null && !h.getChildren().isEmpty()) {
            StringBuilder b = new StringBuilder();
            for (Node n : root.getChildren()) {
                if (!(n instanceof TextNode)) continue;
                b.append(((TextNode)n).getText());
            }
            return b.toString();
        }
        for (Node n : root.getChildren()) {
            String title = this.findTitle(n);
            if (title == null) continue;
            return title;
        }
        return null;
    }

    private RootNode parseMarkdown(String md) {
        return new PegDownProcessor(65527).parseMarkdown(md.toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readPegdownCss(AtomicBoolean file) throws IOException {
        String name = "pegdown.css";
        URL url = MarkdownFormatter.class.getResource(name);
        if (url == null) {
            throw new FileNotFoundException("Resource " + name);
        }
        file.set("file".equals(url.getProtocol()));
        try (InputStream in = url.openStream();){
            String string;
            TemporaryBuffer.Heap tmp = new TemporaryBuffer.Heap(131072);
            try {
                tmp.copy(in);
                string = new String(tmp.toByteArray(), "UTF-8");
            }
            catch (Throwable throwable) {
                tmp.close();
                throw throwable;
            }
            tmp.close();
            return string;
        }
    }

    static {
        String src;
        log = LoggerFactory.getLogger(MarkdownFormatter.class);
        AtomicBoolean file = new AtomicBoolean();
        try {
            src = MarkdownFormatter.readPegdownCss(file);
        }
        catch (IOException err) {
            log.warn("Cannot load pegdown.css", err);
            src = "";
        }
        css = file.get() ? null : src;
    }
}

