/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.lifecycle.LifecycleModule;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.RepositoryCaseMismatchException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.WindowCacheConfig;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LocalDiskRepositoryManager
implements GitRepositoryManager {
    private static final Logger log = LoggerFactory.getLogger(LocalDiskRepositoryManager.class);
    private static final String UNNAMED = "Unnamed repository; edit this file to name it for gitweb.";
    private final File basePath;
    private final Lock namesUpdateLock;
    private volatile SortedSet<Project.NameKey> names;

    @Inject
    LocalDiskRepositoryManager(SitePaths site, @GerritServerConfig Config cfg) {
        this.basePath = site.resolve(cfg.getString("gerrit", null, "basePath"));
        if (this.basePath == null) {
            throw new IllegalStateException("gerrit.basePath must be configured");
        }
        this.namesUpdateLock = new ReentrantLock(true);
        this.names = this.list();
    }

    public File getBasePath() {
        return this.basePath;
    }

    private File gitDirOf(Project.NameKey name) {
        return new File(this.getBasePath(), name.get());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Repository openRepository(Project.NameKey name) throws RepositoryNotFoundException {
        if (this.isUnreasonableName(name)) {
            throw new RepositoryNotFoundException("Invalid name: " + name);
        }
        if (!this.names.contains(name)) {
            if (!name.get().endsWith(".git")) {
                if (RepositoryCache.FileKey.resolve(this.gitDirOf(name), FS.DETECTED) == null) throw new RepositoryNotFoundException(this.gitDirOf(name));
                this.onCreateProject(name);
            } else {
                File directory = this.gitDirOf(name);
                if (RepositoryCache.FileKey.isGitRepository(new File(directory, ".git"), FS.DETECTED)) {
                    this.onCreateProject(name);
                } else {
                    if (!RepositoryCache.FileKey.isGitRepository(new File(directory.getParentFile(), directory.getName() + ".git"), FS.DETECTED)) throw new RepositoryNotFoundException(this.gitDirOf(name));
                    this.onCreateProject(name);
                }
            }
        }
        RepositoryCache.FileKey loc = RepositoryCache.FileKey.lenient(this.gitDirOf(name), FS.DETECTED);
        try {
            return RepositoryCache.open(loc);
        }
        catch (IOException e1) {
            RepositoryNotFoundException e2 = new RepositoryNotFoundException("Cannot open repository " + name);
            e2.initCause(e1);
            throw e2;
        }
    }

    @Override
    public Repository createRepository(Project.NameKey name) throws RepositoryNotFoundException, RepositoryCaseMismatchException {
        RepositoryCache.FileKey loc;
        if (this.isUnreasonableName(name)) {
            throw new RepositoryNotFoundException("Invalid name: " + name);
        }
        File dir = RepositoryCache.FileKey.resolve(this.gitDirOf(name), FS.DETECTED);
        if (dir != null) {
            loc = RepositoryCache.FileKey.exact(dir, FS.DETECTED);
            if (!this.names.contains(name)) {
                throw new RepositoryCaseMismatchException(name);
            }
        } else {
            String n = name.get() + ".git";
            loc = RepositoryCache.FileKey.exact(new File(this.basePath, n), FS.DETECTED);
        }
        try {
            Repository db = RepositoryCache.open(loc, false);
            db.create(true);
            StoredConfig config = db.getConfig();
            config.setBoolean("core", null, "logallrefupdates", true);
            config.save();
            this.onCreateProject(name);
            return db;
        }
        catch (IOException e1) {
            RepositoryNotFoundException e2 = new RepositoryNotFoundException("Cannot create repository " + name);
            e2.initCause(e1);
            throw e2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCreateProject(Project.NameKey newProjectName) {
        this.namesUpdateLock.lock();
        try {
            TreeSet<Project.NameKey> n = new TreeSet<Project.NameKey>(this.names);
            n.add(newProjectName);
            this.names = Collections.unmodifiableSortedSet(n);
        }
        finally {
            this.namesUpdateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProjectDescription(Project.NameKey name) throws RepositoryNotFoundException, IOException {
        try (Repository e = this.openRepository(name);){
            String string = this.getProjectDescription(e);
            return string;
        }
    }

    private String getProjectDescription(Repository e) throws IOException {
        String description;
        File d = new File(e.getDirectory(), "description");
        try {
            description = RawParseUtils.decode(IO.readFully(d));
        }
        catch (FileNotFoundException err) {
            return null;
        }
        if (description != null) {
            if ((description = description.trim()).isEmpty()) {
                description = null;
            }
            if (UNNAMED.equals(description)) {
                description = null;
            }
        }
        return description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProjectDescription(Project.NameKey name, String description) {
        try (Repository e = this.openRepository(name);){
            String old = this.getProjectDescription(e);
            if (old == null && description == null || old != null && old.equals(description)) {
                return;
            }
            LockFile f = new LockFile(new File(e.getDirectory(), "description"), FS.DETECTED);
            if (f.lock()) {
                String d = description;
                if (d != null) {
                    if ((d = d.trim()).length() > 0) {
                        d = d + "\n";
                    }
                } else {
                    d = "";
                }
                f.write(Constants.encode(d));
                f.commit();
            }
        }
        catch (RepositoryNotFoundException e2) {
            log.error("Cannot update description for " + name, e2);
        }
        catch (IOException e3) {
            log.error("Cannot update description for " + name, e3);
        }
    }

    private boolean isUnreasonableName(Project.NameKey nameKey) {
        String name = nameKey.get();
        if (name.length() == 0) {
            return true;
        }
        if (name.charAt(name.length() - 1) == '/') {
            return true;
        }
        if (name.indexOf(92) >= 0) {
            return true;
        }
        if (name.charAt(0) == '/') {
            return true;
        }
        if (new File(name).isAbsolute()) {
            return true;
        }
        if (name.startsWith("../")) {
            return true;
        }
        if (name.contains("/../")) {
            return true;
        }
        if (name.contains("/./")) {
            return true;
        }
        if (name.contains("//")) {
            return true;
        }
        if (name.contains("?")) {
            return true;
        }
        if (name.contains("%")) {
            return true;
        }
        if (name.contains("*")) {
            return true;
        }
        if (name.contains(":")) {
            return true;
        }
        if (name.contains("<")) {
            return true;
        }
        if (name.contains(">")) {
            return true;
        }
        if (name.contains("|")) {
            return true;
        }
        if (name.contains("$")) {
            return true;
        }
        return name.contains("\r");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSet<Project.NameKey> list() {
        this.namesUpdateLock.lock();
        try {
            TreeSet<Project.NameKey> n = new TreeSet<Project.NameKey>();
            this.scanProjects(this.basePath, "", n);
            this.names = Collections.unmodifiableSortedSet(n);
            TreeSet<Project.NameKey> treeSet = n;
            return treeSet;
        }
        finally {
            this.namesUpdateLock.unlock();
        }
    }

    private void scanProjects(File dir, String prefix, SortedSet<Project.NameKey> names) {
        File[] ls = dir.listFiles();
        if (ls == null) {
            return;
        }
        for (File f : ls) {
            String fileName = f.getName();
            if (fileName.equals(".git")) continue;
            if (RepositoryCache.FileKey.isGitRepository(f, FS.DETECTED)) {
                Project.NameKey nameKey = this.getProjectName(prefix, fileName);
                if (this.isUnreasonableName(nameKey)) {
                    log.warn("Ignoring unreasonably named repository " + f.getAbsolutePath());
                    continue;
                }
                names.add(nameKey);
                continue;
            }
            if (!f.isDirectory()) continue;
            this.scanProjects(f, prefix + f.getName() + "/", names);
        }
    }

    private Project.NameKey getProjectName(String prefix, String fileName) {
        String projectName;
        if (fileName.endsWith(".git")) {
            int newLen = fileName.length() - ".git".length();
            projectName = prefix + fileName.substring(0, newLen);
        } else {
            projectName = prefix + fileName;
        }
        return new Project.NameKey(projectName);
    }

    public static class Lifecycle
    implements LifecycleListener {
        private final Config serverConfig;

        @Inject
        Lifecycle(@GerritServerConfig Config cfg) {
            this.serverConfig = cfg;
        }

        @Override
        public void start() {
            SshSessionFactory.setInstance(new JschConfigSessionFactory(){

                @Override
                protected void configure(OpenSshConfig.Host hc, Session session) {
                }
            });
            WindowCacheConfig cfg = new WindowCacheConfig();
            cfg.fromConfig(this.serverConfig);
            if (this.serverConfig.getString("core", null, "streamFileThreshold") == null) {
                long mx = Runtime.getRuntime().maxMemory();
                int limit = (int)Math.min(mx / 4L, 0x7FF00000L);
                if (0x500000 < limit && limit % 0x100000 != 0) {
                    limit = limit / 0x100000 + 1 << 20;
                }
                String desc = limit % 0x100000 == 0 ? String.format("%dm", limit / 0x100000) : (limit % 1024 == 0 ? String.format("%dk", limit / 1024) : String.format("%d", limit));
                log.info(String.format("Defaulting core.streamFileThreshold to %s", desc));
                cfg.setStreamFileThreshold(limit);
            }
            cfg.install();
        }

        @Override
        public void stop() {
        }
    }

    public static class Module
    extends LifecycleModule {
        @Override
        protected void configure() {
            this.bind(GitRepositoryManager.class).to(LocalDiskRepositoryManager.class);
            this.listener().to(Lifecycle.class);
        }
    }
}

