/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;

public class MetaDataUpdate {
    private final GitReferenceUpdated gitRefUpdated;
    private final Project.NameKey projectName;
    private final Repository db;
    private final CommitBuilder commit;
    private boolean allowEmpty;

    @Inject
    public MetaDataUpdate(GitReferenceUpdated gitRefUpdated, @Assisted Project.NameKey projectName, @Assisted Repository db) {
        this.gitRefUpdated = gitRefUpdated;
        this.projectName = projectName;
        this.db = db;
        this.commit = new CommitBuilder();
    }

    public void setMessage(String message) {
        this.getCommitBuilder().setMessage(message);
    }

    public void setAuthor(IdentifiedUser user) {
        this.getCommitBuilder().setAuthor(user.newCommitterIdent(this.getCommitBuilder().getCommitter().getWhen(), this.getCommitBuilder().getCommitter().getTimeZone()));
    }

    public void setAllowEmpty(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }

    public void close() {
        this.getRepository().close();
    }

    Project.NameKey getProjectName() {
        return this.projectName;
    }

    public Repository getRepository() {
        return this.db;
    }

    boolean allowEmpty() {
        return this.allowEmpty;
    }

    public CommitBuilder getCommitBuilder() {
        return this.commit;
    }

    void fireGitRefUpdatedEvent(RefUpdate ru) {
        this.gitRefUpdated.fire(this.projectName, ru);
    }

    static interface InternalFactory {
        public MetaDataUpdate create(@Assisted Project.NameKey var1, @Assisted Repository var2);
    }

    public static class Server {
        private final InternalFactory factory;
        private final GitRepositoryManager mgr;
        private final PersonIdent serverIdent;

        @Inject
        Server(InternalFactory factory, GitRepositoryManager mgr, @GerritPersonIdent PersonIdent serverIdent) {
            this.factory = factory;
            this.mgr = mgr;
            this.serverIdent = serverIdent;
        }

        public MetaDataUpdate create(Project.NameKey name) throws RepositoryNotFoundException, IOException {
            MetaDataUpdate md = this.factory.create(name, this.mgr.openRepository(name));
            md.getCommitBuilder().setAuthor(this.serverIdent);
            md.getCommitBuilder().setCommitter(this.serverIdent);
            return md;
        }
    }

    public static class User {
        private final InternalFactory factory;
        private final GitRepositoryManager mgr;
        private final PersonIdent serverIdent;
        private final Provider<IdentifiedUser> identifiedUser;

        @Inject
        User(InternalFactory factory, GitRepositoryManager mgr, @GerritPersonIdent PersonIdent serverIdent, Provider<IdentifiedUser> identifiedUser) {
            this.factory = factory;
            this.mgr = mgr;
            this.serverIdent = serverIdent;
            this.identifiedUser = identifiedUser;
        }

        public PersonIdent getUserPersonIdent() {
            return this.createPersonIdent(this.identifiedUser.get());
        }

        public MetaDataUpdate create(Project.NameKey name) throws RepositoryNotFoundException, IOException {
            return this.create(name, this.identifiedUser.get());
        }

        public MetaDataUpdate create(Project.NameKey name, IdentifiedUser user) throws RepositoryNotFoundException, IOException {
            MetaDataUpdate md = this.factory.create(name, this.mgr.openRepository(name));
            md.getCommitBuilder().setAuthor(this.createPersonIdent(user));
            md.getCommitBuilder().setCommitter(this.serverIdent);
            return md;
        }

        private PersonIdent createPersonIdent(IdentifiedUser user) {
            return user.newCommitterIdent(this.serverIdent.getWhen(), this.serverIdent.getTimeZone());
        }
    }
}

