/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.project.ProjectState;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.storage.pack.PackConfig;

@Singleton
public class TransferConfig {
    private final int timeout;
    private final PackConfig packConfig;
    private final long maxObjectSizeLimit;
    private final String maxObjectSizeLimitFormatted;

    @Inject
    TransferConfig(@GerritServerConfig Config cfg) {
        this.timeout = (int)ConfigUtil.getTimeUnit(cfg, "transfer", null, "timeout", 0L, TimeUnit.SECONDS);
        this.maxObjectSizeLimit = cfg.getLong("receive", "maxObjectSizeLimit", 0L);
        this.maxObjectSizeLimitFormatted = cfg.getString("receive", null, "maxObjectSizeLimit");
        this.packConfig = new PackConfig();
        this.packConfig.setDeltaCompress(false);
        this.packConfig.setThreads(1);
        this.packConfig.fromConfig(cfg);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public PackConfig getPackConfig() {
        return this.packConfig;
    }

    public long getMaxObjectSizeLimit() {
        return this.maxObjectSizeLimit;
    }

    public String getFormattedMaxObjectSizeLimit() {
        return this.maxObjectSizeLimitFormatted;
    }

    public long getEffectiveMaxObjectSizeLimit(ProjectState p) {
        long global = this.getMaxObjectSizeLimit();
        long local = p.getMaxObjectSizeLimit();
        if (global > 0L && local > 0L) {
            return Math.min(global, local);
        }
        return Math.max(global, local);
    }
}

