/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.git.ChangeCache;
import com.google.gerrit.server.git.TagCache;
import com.google.gerrit.server.git.TagMatcher;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gwtorm.server.OrmException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.AbstractAdvertiseRefsHook;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisibleRefFilter
extends AbstractAdvertiseRefsHook {
    private static final Logger log = LoggerFactory.getLogger(VisibleRefFilter.class);
    private final TagCache tagCache;
    private final ChangeCache changeCache;
    private final Repository db;
    private final Project.NameKey projectName;
    private final ProjectControl projectCtl;
    private final ReviewDb reviewDb;
    private final boolean showChanges;

    public VisibleRefFilter(TagCache tagCache, ChangeCache changeCache, Repository db, ProjectControl projectControl, ReviewDb reviewDb, boolean showChanges) {
        this.tagCache = tagCache;
        this.changeCache = changeCache;
        this.db = db;
        this.projectName = projectControl.getProject().getNameKey();
        this.projectCtl = projectControl;
        this.reviewDb = reviewDb;
        this.showChanges = showChanges;
    }

    public Map<String, Ref> filter(Map<String, Ref> refs, boolean filterTagsSeperately) {
        if (this.projectCtl.allRefsAreVisibleExcept(ImmutableSet.of("refs/meta/config"))) {
            HashMap<String, Ref> r = Maps.newHashMap(refs);
            r.remove("refs/meta/config");
            return r;
        }
        Set<Change.Id> visibleChanges = this.visibleChanges();
        HashMap<String, Ref> result = new HashMap<String, Ref>();
        ArrayList<Ref> deferredTags = new ArrayList<Ref>();
        for (Ref ref : refs.values()) {
            if (ref.getName().startsWith("refs/cache-automerge/")) continue;
            if (PatchSet.isRef(ref.getName())) {
                if (!this.showChanges || !visibleChanges.contains(Change.Id.fromRef(ref.getName()))) continue;
                result.put(ref.getName(), ref);
                continue;
            }
            if (VisibleRefFilter.isTag(ref)) {
                if (ref.getObjectId() == null) continue;
                deferredTags.add(ref);
                continue;
            }
            if (!this.projectCtl.controlForRef(ref.getLeaf().getName()).isVisible()) continue;
            result.put(ref.getName(), ref);
        }
        if (!(deferredTags.isEmpty() || result.isEmpty() && !filterTagsSeperately)) {
            TagMatcher tags = this.tagCache.get(this.projectName).matcher(this.tagCache, this.db, filterTagsSeperately ? this.filter(this.db.getAllRefs()).values() : result.values());
            for (Ref tag : deferredTags) {
                if (!tags.isReachable(tag)) continue;
                result.put(tag.getName(), tag);
            }
        }
        return result;
    }

    @Override
    protected Map<String, Ref> getAdvertisedRefs(Repository repository, RevWalk revWalk) throws ServiceMayNotContinueException {
        try {
            return this.filter(repository.getRefDatabase().getRefs(""));
        }
        catch (ServiceMayNotContinueException e) {
            throw e;
        }
        catch (IOException e) {
            ServiceMayNotContinueException ex = new ServiceMayNotContinueException();
            ex.initCause(e);
            throw ex;
        }
    }

    private Map<String, Ref> filter(Map<String, Ref> refs) {
        return this.filter(refs, false);
    }

    private Set<Change.Id> visibleChanges() {
        if (!this.showChanges) {
            return Collections.emptySet();
        }
        Project project = this.projectCtl.getProject();
        try {
            HashSet<Change.Id> visibleChanges = new HashSet<Change.Id>();
            for (Change change : this.changeCache.get(project.getNameKey())) {
                if (!this.projectCtl.controlFor(change).isVisible(this.reviewDb)) continue;
                visibleChanges.add(change.getId());
            }
            return visibleChanges;
        }
        catch (OrmException e) {
            log.error("Cannot load changes for project " + project.getName() + ", assuming no changes are visible", e);
            return Collections.emptySet();
        }
    }

    private static boolean isTag(Ref ref) {
        return ref.getLeaf().getName().startsWith("refs/tags/");
    }
}

