/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.strategy;

import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.CommitMergeStatus;
import com.google.gerrit.server.git.MergeException;
import com.google.gerrit.server.git.strategy.SubmitStrategy;
import java.util.List;

public class FastForwardOnly
extends SubmitStrategy {
    FastForwardOnly(SubmitStrategy.Arguments args) {
        super(args);
    }

    @Override
    protected CodeReviewCommit _run(CodeReviewCommit mergeTip, List<CodeReviewCommit> toMerge) throws MergeException {
        this.args.mergeUtil.reduceToMinimalMerge(this.args.mergeSorter, toMerge);
        CodeReviewCommit newMergeTip = this.args.mergeUtil.getFirstFastForward(mergeTip, this.args.rw, toMerge);
        while (!toMerge.isEmpty()) {
            CodeReviewCommit n = toMerge.remove(0);
            n.setStatusCode(CommitMergeStatus.NOT_FAST_FORWARD);
        }
        PatchSetApproval submitApproval = this.args.mergeUtil.markCleanMerges(this.args.rw, this.args.canMergeFlag, newMergeTip, this.args.alreadyAccepted);
        this.setRefLogIdent(submitApproval);
        return newMergeTip;
    }

    @Override
    public boolean retryOnLockFailure() {
        return false;
    }

    @Override
    public boolean dryRun(CodeReviewCommit mergeTip, CodeReviewCommit toMerge) throws MergeException {
        return this.args.mergeUtil.canFastForward(this.args.mergeSorter, mergeTip, this.args.rw, toMerge);
    }
}

