/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupById;
import com.google.gerrit.reviewdb.client.AccountGroupByIdAud;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.account.GroupIncludeCache;
import com.google.gerrit.server.group.AddIncludedGroups;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.GroupsCollection;
import com.google.gerrit.server.group.IncludedGroupResource;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@Singleton
public class DeleteIncludedGroups
implements RestModifyView<GroupResource, AddIncludedGroups.Input> {
    private final GroupsCollection groupsCollection;
    private final GroupIncludeCache groupIncludeCache;
    private final Provider<ReviewDb> db;
    private final Provider<CurrentUser> self;

    @Inject
    DeleteIncludedGroups(GroupsCollection groupsCollection, GroupIncludeCache groupIncludeCache, Provider<ReviewDb> db, Provider<CurrentUser> self) {
        this.groupsCollection = groupsCollection;
        this.groupIncludeCache = groupIncludeCache;
        this.db = db;
        this.self = self;
    }

    public Response<?> apply(GroupResource resource, AddIncludedGroups.Input input) throws AuthException, MethodNotAllowedException, UnprocessableEntityException, OrmException {
        AccountGroup internalGroup = resource.toAccountGroup();
        if (internalGroup == null) {
            throw new MethodNotAllowedException();
        }
        input = AddIncludedGroups.Input.init(input);
        GroupControl control = resource.getControl();
        Map<AccountGroup.UUID, AccountGroupById> includedGroups = this.getIncludedGroups(internalGroup.getId());
        LinkedList<AccountGroupById> toRemove = Lists.newLinkedList();
        for (String includedGroup : input.groups) {
            GroupDescription.Basic d = this.groupsCollection.parse(includedGroup);
            if (!control.canRemoveGroup(d.getGroupUUID())) {
                throw new AuthException(String.format("Cannot delete group: %s", d.getName()));
            }
            AccountGroupById g = includedGroups.remove(d.getGroupUUID());
            if (g == null) continue;
            toRemove.add(g);
        }
        if (!toRemove.isEmpty()) {
            this.writeAudits(toRemove);
            this.db.get().accountGroupById().delete(toRemove);
            for (AccountGroupById g : toRemove) {
                this.groupIncludeCache.evictMemberIn(g.getIncludeUUID());
            }
            this.groupIncludeCache.evictMembersOf(internalGroup.getGroupUUID());
        }
        return Response.none();
    }

    private Map<AccountGroup.UUID, AccountGroupById> getIncludedGroups(AccountGroup.Id groupId) throws OrmException {
        HashMap<AccountGroup.UUID, AccountGroupById> groups = Maps.newHashMap();
        for (AccountGroupById g : this.db.get().accountGroupById().byGroup(groupId)) {
            groups.put(g.getIncludeUUID(), g);
        }
        return groups;
    }

    private void writeAudits(List<AccountGroupById> toBeRemoved) throws OrmException {
        Account.Id me = ((IdentifiedUser)this.self.get()).getAccountId();
        LinkedList<AccountGroupByIdAud> auditUpdates = Lists.newLinkedList();
        for (AccountGroupById g : toBeRemoved) {
            AccountGroupByIdAud audit = null;
            for (AccountGroupByIdAud a : this.db.get().accountGroupByIdAud().byGroupInclude(g.getGroupId(), g.getIncludeUUID())) {
                if (!a.isActive()) continue;
                audit = a;
                break;
            }
            if (audit == null) continue;
            audit.removed(me, TimeUtil.nowTs());
            auditUpdates.add(audit);
        }
        this.db.get().accountGroupByIdAud().update(auditUpdates);
    }

    @Singleton
    static class DeleteIncludedGroup
    implements RestModifyView<IncludedGroupResource, Input> {
        private final Provider<DeleteIncludedGroups> delete;

        @Inject
        DeleteIncludedGroup(Provider<DeleteIncludedGroups> delete) {
            this.delete = delete;
        }

        public Response<?> apply(IncludedGroupResource resource, Input input) throws AuthException, MethodNotAllowedException, UnprocessableEntityException, OrmException {
            AddIncludedGroups.Input in = new AddIncludedGroups.Input();
            in.groups = ImmutableList.of(resource.getMember().get());
            return this.delete.get().apply(resource, in);
        }

        static class Input {
            Input() {
            }
        }
    }
}

