/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.group.GroupOptionsInfo;
import com.google.gerrit.server.group.GroupResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Collections;

@Singleton
public class PutOptions
implements RestModifyView<GroupResource, Input> {
    private final GroupCache groupCache;
    private final Provider<ReviewDb> db;

    @Inject
    PutOptions(GroupCache groupCache, Provider<ReviewDb> db) {
        this.groupCache = groupCache;
        this.db = db;
    }

    public GroupOptionsInfo apply(GroupResource resource, Input input) throws MethodNotAllowedException, AuthException, BadRequestException, ResourceNotFoundException, OrmException {
        AccountGroup group;
        if (resource.toAccountGroup() == null) {
            throw new MethodNotAllowedException();
        }
        if (!resource.getControl().isOwner()) {
            throw new AuthException("Not group owner");
        }
        if (input == null) {
            throw new BadRequestException("options are required");
        }
        if (input.visibleToAll == null) {
            input.visibleToAll = false;
        }
        if ((group = this.db.get().accountGroups().get(resource.toAccountGroup().getId())) == null) {
            throw new ResourceNotFoundException();
        }
        group.setVisibleToAll(input.visibleToAll);
        this.db.get().accountGroups().update(Collections.singleton(group));
        this.groupCache.evict(group);
        return new GroupOptionsInfo(group);
    }

    public static class Input {
        public Boolean visibleToAll;
    }
}

