/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.change.MergeabilityChecker;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MultiProgressMonitor;
import com.google.gerrit.server.index.ChangeIndex;
import com.google.gerrit.server.index.ChangeIndexer;
import com.google.gerrit.server.index.IndexExecutor;
import com.google.gerrit.server.patch.PatchListLoader;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.Schema;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.io.DisabledOutputStream;
import org.eclipse.jgit.util.io.NullOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeBatchIndexer {
    private static final Logger log = LoggerFactory.getLogger(ChangeBatchIndexer.class);
    private final SchemaFactory<ReviewDb> schemaFactory;
    private final ChangeData.Factory changeDataFactory;
    private final GitRepositoryManager repoManager;
    private final ListeningExecutorService executor;
    private final ChangeIndexer.Factory indexerFactory;
    private final MergeabilityChecker mergeabilityChecker;

    @Inject
    ChangeBatchIndexer(SchemaFactory<ReviewDb> schemaFactory, ChangeData.Factory changeDataFactory, GitRepositoryManager repoManager, @IndexExecutor ListeningExecutorService executor, ChangeIndexer.Factory indexerFactory, @Nullable MergeabilityChecker mergeabilityChecker) {
        this.schemaFactory = schemaFactory;
        this.changeDataFactory = changeDataFactory;
        this.repoManager = repoManager;
        this.executor = executor;
        this.indexerFactory = indexerFactory;
        this.mergeabilityChecker = mergeabilityChecker;
    }

    public Result indexAll(ChangeIndex index, Iterable<Project.NameKey> projects, int numProjects, int numChanges, OutputStream progressOut, OutputStream verboseOut) {
        if (progressOut == null) {
            progressOut = NullOutputStream.INSTANCE;
        }
        PrintWriter verboseWriter = verboseOut != null ? new PrintWriter(verboseOut) : null;
        Stopwatch sw = Stopwatch.createStarted();
        final MultiProgressMonitor mpm = new MultiProgressMonitor(progressOut, "Reindexing changes");
        final MultiProgressMonitor.Task projTask = mpm.beginSubTask("projects", numProjects >= 0 ? numProjects : 0);
        MultiProgressMonitor.Task doneTask = mpm.beginSubTask(null, numChanges >= 0 ? numChanges : 0);
        MultiProgressMonitor.Task failedTask = mpm.beginSubTask("failed", 0);
        ArrayList<ListenableFuture<Void>> futures = Lists.newArrayList();
        final AtomicBoolean ok = new AtomicBoolean(true);
        for (final Project.NameKey project : projects) {
            if (!this.updateMergeable(project)) {
                ok.set(false);
            }
            final ListenableFuture<Void> future = this.executor.submit(this.reindexProject(this.indexerFactory.create(index), project, doneTask, failedTask, verboseWriter));
            futures.add(future);
            future.addListener(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        future.get();
                    }
                    catch (InterruptedException e) {
                        this.fail(project, e);
                    }
                    catch (ExecutionException e) {
                        this.fail(project, e);
                    }
                    catch (RuntimeException e) {
                        this.failAndThrow(project, e);
                    }
                    catch (Error e) {
                        this.failAndThrow(project, e);
                    }
                    finally {
                        projTask.update(1);
                    }
                }

                private void fail(Project.NameKey project2, Throwable t) {
                    log.error("Failed to index project " + project2, t);
                    ok.set(false);
                }

                private void failAndThrow(Project.NameKey project2, RuntimeException e) {
                    this.fail(project2, e);
                    throw e;
                }

                private void failAndThrow(Project.NameKey project2, Error e) {
                    this.fail(project2, e);
                    throw e;
                }
            }, MoreExecutors.sameThreadExecutor());
        }
        try {
            mpm.waitFor(Futures.transform(Futures.successfulAsList(futures), new AsyncFunction<List<?>, Void>(){

                @Override
                public ListenableFuture<Void> apply(List<?> input) {
                    mpm.end();
                    return Futures.immediateFuture(null);
                }
            }));
        }
        catch (ExecutionException e) {
            log.error("Error in batch indexer", e);
            ok.set(false);
        }
        return new Result(sw, ok.get(), doneTask.getCount(), failedTask.getCount());
    }

    private boolean updateMergeable(Project.NameKey project) {
        if (this.mergeabilityChecker != null) {
            try {
                this.mergeabilityChecker.newCheck().addProject(project).run();
            }
            catch (IOException e) {
                log.error("Error in mergeability checker", e);
                return false;
            }
        }
        return true;
    }

    private Callable<Void> reindexProject(final ChangeIndexer indexer, final Project.NameKey project, final MultiProgressMonitor.Task done, final MultiProgressMonitor.Task failed, final PrintWriter verboseWriter) {
        return new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                ArrayListMultimap<ObjectId, ChangeData> byId = ArrayListMultimap.create();
                Repository repo = null;
                Schema db = null;
                try {
                    repo = ChangeBatchIndexer.this.repoManager.openRepository(project);
                    Map<String, Ref> refs = repo.getRefDatabase().getRefs("");
                    db = (ReviewDb)ChangeBatchIndexer.this.schemaFactory.open();
                    for (Change c : db.changes().byProject(project)) {
                        Ref r = refs.get(c.currentPatchSetId().toRefName());
                        if (r == null) continue;
                        byId.put(r.getObjectId(), ChangeBatchIndexer.this.changeDataFactory.create((ReviewDb)db, c));
                    }
                    new ProjectIndexer(indexer, byId, repo, done, failed, verboseWriter).call();
                }
                catch (RepositoryNotFoundException rnfe) {
                    log.error(rnfe.getMessage());
                }
                finally {
                    if (db != null) {
                        db.close();
                    }
                    if (repo != null) {
                        repo.close();
                    }
                }
                return null;
            }
        };
    }

    public static class ProjectIndexer
    implements Callable<Void> {
        private final ChangeIndexer indexer;
        private final Multimap<ObjectId, ChangeData> byId;
        private final ProgressMonitor done;
        private final ProgressMonitor failed;
        private final PrintWriter verboseWriter;
        private final Repository repo;
        private RevWalk walk;

        public ProjectIndexer(ChangeIndexer indexer, Multimap<ObjectId, ChangeData> changesByCommitId, Repository repo) {
            this(indexer, changesByCommitId, repo, NullProgressMonitor.INSTANCE, NullProgressMonitor.INSTANCE, null);
        }

        ProjectIndexer(ChangeIndexer indexer, Multimap<ObjectId, ChangeData> changesByCommitId, Repository repo, ProgressMonitor done, ProgressMonitor failed, PrintWriter verboseWriter) {
            this.indexer = indexer;
            this.byId = changesByCommitId;
            this.repo = repo;
            this.done = done;
            this.failed = failed;
            this.verboseWriter = verboseWriter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            this.walk = new RevWalk(this.repo);
            try {
                RevCommit bCommit;
                for (Ref ref : this.repo.getRefDatabase().getRefs("refs/heads/").values()) {
                    RevObject o = this.walk.parseAny(ref.getObjectId());
                    if (!(o instanceof RevCommit)) continue;
                    this.walk.markStart((RevCommit)o);
                }
                while ((bCommit = this.walk.next()) != null && !this.byId.isEmpty()) {
                    if (!this.byId.containsKey(bCommit)) continue;
                    this.getPathsAndIndex(bCommit);
                    this.byId.removeAll(bCommit);
                }
                for (ObjectId id : this.byId.keySet()) {
                    this.getPathsAndIndex(id);
                }
            }
            finally {
                this.walk.release();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getPathsAndIndex(ObjectId b) throws Exception {
            block10: {
                ArrayList<ChangeData> cds = Lists.newArrayList(this.byId.get(b));
                try {
                    RevCommit bCommit = this.walk.parseCommit(b);
                    RevTree bTree = bCommit.getTree();
                    RevTree aTree = this.aFor(bCommit, this.walk);
                    DiffFormatter df = new DiffFormatter(DisabledOutputStream.INSTANCE);
                    try {
                        df.setRepository(this.repo);
                        if (cds.isEmpty()) break block10;
                        List<String> paths = aTree != null ? this.getPaths(df.scan(aTree, bTree)) : Collections.emptyList();
                        Iterator cdit = cds.iterator();
                        while (cdit.hasNext()) {
                            ChangeData cd = (ChangeData)cdit.next();
                            try {
                                cd.setCurrentFilePaths(paths);
                                this.indexer.index(cd);
                                this.done.update(1);
                                if (this.verboseWriter != null) {
                                    this.verboseWriter.println("Reindexed change " + cd.getId());
                                }
                            }
                            catch (Exception e) {
                                this.fail("Failed to index change " + cd.getId(), true, e);
                            }
                            cdit.remove();
                        }
                    }
                    finally {
                        df.release();
                    }
                }
                catch (Exception e) {
                    this.fail("Failed to index commit " + b.name(), false, e);
                    for (ChangeData cd : cds) {
                        this.fail("Failed to index change " + cd.getId(), true, null);
                    }
                }
            }
        }

        private List<String> getPaths(List<DiffEntry> filenames) {
            TreeSet<String> paths = Sets.newTreeSet();
            for (DiffEntry e : filenames) {
                if (e.getOldPath() != null) {
                    paths.add(e.getOldPath());
                }
                if (e.getNewPath() == null) continue;
                paths.add(e.getNewPath());
            }
            return ImmutableList.copyOf(paths);
        }

        private RevTree aFor(RevCommit b, RevWalk walk) throws IOException {
            switch (b.getParentCount()) {
                case 0: {
                    return walk.parseTree(this.emptyTree());
                }
                case 1: {
                    RevCommit a = b.getParent(0);
                    walk.parseBody(a);
                    return walk.parseTree(a.getTree());
                }
                case 2: {
                    return PatchListLoader.automerge(this.repo, walk, b);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ObjectId emptyTree() throws IOException {
            ObjectInserter oi = this.repo.newObjectInserter();
            try {
                ObjectId id = oi.insert(2, new byte[0]);
                oi.flush();
                ObjectId objectId = id;
                return objectId;
            }
            finally {
                oi.release();
            }
        }

        private void fail(String error, boolean failed, Exception e) {
            if (failed) {
                this.failed.update(1);
            }
            if (e != null) {
                log.warn(error, e);
            } else {
                log.warn(error);
            }
            if (this.verboseWriter != null) {
                this.verboseWriter.println(error);
            }
        }
    }

    public static class Result {
        private final long elapsedNanos;
        private final boolean success;
        private final int done;
        private final int failed;

        private Result(Stopwatch sw, boolean success, int done, int failed) {
            this.elapsedNanos = sw.elapsed(TimeUnit.NANOSECONDS);
            this.success = success;
            this.done = done;
            this.failed = failed;
        }

        public boolean success() {
            return this.success;
        }

        public int doneCount() {
            return this.done;
        }

        public int failedCount() {
            return this.failed;
        }

        public long elapsed(TimeUnit timeUnit) {
            return timeUnit.convert(this.elapsedNanos, TimeUnit.NANOSECONDS);
        }
    }
}

