/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index;

import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.index.FieldDef;
import com.google.gerrit.server.index.FieldType;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeStatusPredicate;
import com.google.gwtorm.protobuf.CodecFactory;
import com.google.gwtorm.protobuf.ProtobufCodec;
import com.google.gwtorm.server.OrmException;
import com.google.protobuf.CodedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ChangeField {
    public static final FieldDef<ChangeData, Integer> LEGACY_ID = new FieldDef.Single<ChangeData, Integer>("_id", FieldType.INTEGER, true){

        @Override
        public Integer get(ChangeData input, FieldDef.FillArgs args) {
            return input.getId().get();
        }
    };
    public static final FieldDef<ChangeData, String> ID = new FieldDef.Single<ChangeData, String>("change_id", FieldType.PREFIX, false){

        @Override
        public String get(ChangeData input, FieldDef.FillArgs args) throws OrmException {
            return input.change().getKey().get();
        }
    };
    public static final FieldDef<ChangeData, String> STATUS = new FieldDef.Single<ChangeData, String>("status", FieldType.EXACT, false){

        @Override
        public String get(ChangeData input, FieldDef.FillArgs args) throws OrmException {
            return (String)ChangeStatusPredicate.VALUES.get((Object)input.change().getStatus());
        }
    };
    public static final FieldDef<ChangeData, String> PROJECT = new FieldDef.Single<ChangeData, String>("project", FieldType.EXACT, false){

        @Override
        public String get(ChangeData input, FieldDef.FillArgs args) throws OrmException {
            return input.change().getProject().get();
        }
    };
    public static final FieldDef<ChangeData, String> PROJECTS = new FieldDef.Single<ChangeData, String>("projects", FieldType.PREFIX, false){

        @Override
        public String get(ChangeData input, FieldDef.FillArgs args) throws OrmException {
            return input.change().getProject().get();
        }
    };
    public static final FieldDef<ChangeData, String> REF = new FieldDef.Single<ChangeData, String>("ref", FieldType.EXACT, false){

        @Override
        public String get(ChangeData input, FieldDef.FillArgs args) throws OrmException {
            return input.change().getDest().get();
        }
    };
    @Deprecated
    public static final FieldDef<ChangeData, String> LEGACY_TOPIC = new FieldDef.Single<ChangeData, String>("topic", FieldType.EXACT, false){

        @Override
        public String get(ChangeData input, FieldDef.FillArgs args) throws OrmException {
            return input.change().getTopic();
        }
    };
    public static final FieldDef<ChangeData, String> TOPIC = new FieldDef.Single<ChangeData, String>("topic2", FieldType.EXACT, false){

        @Override
        public String get(ChangeData input, FieldDef.FillArgs args) throws OrmException {
            return Objects.firstNonNull(input.change().getTopic(), "");
        }
    };
    @Deprecated
    public static final FieldDef<ChangeData, Timestamp> LEGACY_UPDATED = new FieldDef.Single<ChangeData, Timestamp>("updated", FieldType.TIMESTAMP, true){

        @Override
        public Timestamp get(ChangeData input, FieldDef.FillArgs args) throws OrmException {
            return input.change().getLastUpdatedOn();
        }
    };
    public static final FieldDef<ChangeData, Timestamp> UPDATED = new FieldDef.Single<ChangeData, Timestamp>("updated2", FieldType.TIMESTAMP, true){

        @Override
        public Timestamp get(ChangeData input, FieldDef.FillArgs args) throws OrmException {
            return input.change().getLastUpdatedOn();
        }
    };
    @Deprecated
    public static final FieldDef<ChangeData, Long> LEGACY_SORTKEY = new FieldDef.Single<ChangeData, Long>("sortkey", FieldType.LONG, true){

        @Override
        public Long get(ChangeData input, FieldDef.FillArgs args) throws OrmException {
            return ChangeField.legacyParseSortKey(input.change().getSortKey());
        }
    };
    @Deprecated
    public static final FieldDef<ChangeData, Long> SORTKEY = new FieldDef.Single<ChangeData, Long>("sortkey2", FieldType.LONG, true){

        @Override
        public Long get(ChangeData input, FieldDef.FillArgs args) throws OrmException {
            return ChangeUtil.parseSortKey(input.change().getSortKey());
        }
    };
    public static final FieldDef<ChangeData, Iterable<String>> PATH = new FieldDef.Repeatable<ChangeData, String>("file", FieldType.EXACT, false){

        @Override
        public Iterable<String> get(ChangeData input, FieldDef.FillArgs args) throws OrmException {
            return input.currentFilePaths();
        }
    };
    public static final FieldDef<ChangeData, Iterable<String>> FILE_PART = new FieldDef.Repeatable<ChangeData, String>("filepart", FieldType.EXACT, false){

        @Override
        public Iterable<String> get(ChangeData input, FieldDef.FillArgs args) throws OrmException {
            return ChangeField.getFileParts(input);
        }
    };
    public static final FieldDef<ChangeData, Integer> OWNER = new FieldDef.Single<ChangeData, Integer>("owner", FieldType.INTEGER, false){

        @Override
        public Integer get(ChangeData input, FieldDef.FillArgs args) throws OrmException {
            return input.change().getOwner().get();
        }
    };
    public static final FieldDef<ChangeData, Iterable<Integer>> REVIEWER = new FieldDef.Repeatable<ChangeData, Integer>("reviewer", FieldType.INTEGER, false){

        @Override
        public Iterable<Integer> get(ChangeData input, FieldDef.FillArgs args) throws OrmException {
            HashSet<Integer> r = Sets.newHashSet();
            if (!args.allowsDrafts && input.change().getStatus() == Change.Status.DRAFT) {
                return r;
            }
            for (PatchSetApproval a : input.approvals().values()) {
                r.add(a.getAccountId().get());
            }
            return r;
        }
    };
    public static final FieldDef<ChangeData, Iterable<String>> COMMIT = new FieldDef.Repeatable<ChangeData, String>("commit", FieldType.PREFIX, false){

        @Override
        public Iterable<String> get(ChangeData input, FieldDef.FillArgs args) throws OrmException {
            HashSet<String> revisions = Sets.newHashSet();
            for (PatchSet ps : input.patches()) {
                if (ps.getRevision() == null) continue;
                revisions.add(ps.getRevision().get());
            }
            return revisions;
        }
    };
    public static final FieldDef<ChangeData, Iterable<String>> TR = new FieldDef.Repeatable<ChangeData, String>("tr", FieldType.EXACT, false){

        @Override
        public Iterable<String> get(ChangeData input, FieldDef.FillArgs args) throws OrmException {
            try {
                return Sets.newHashSet(args.trackingFooters.extract(input.commitFooters()).values());
            }
            catch (NoSuchChangeException | IOException e) {
                throw new OrmException(e);
            }
        }
    };
    public static final FieldDef<ChangeData, Iterable<String>> LABEL = new FieldDef.Repeatable<ChangeData, String>("label", FieldType.EXACT, false){

        @Override
        public Iterable<String> get(ChangeData input, FieldDef.FillArgs args) throws OrmException {
            HashSet<String> allApprovals = Sets.newHashSet();
            HashSet<String> distinctApprovals = Sets.newHashSet();
            for (PatchSetApproval a : input.currentApprovals()) {
                if (a.getValue() == 0 || a.isSubmit()) continue;
                allApprovals.add(ChangeField.formatLabel(a.getLabel(), a.getValue(), a.getAccountId()));
                distinctApprovals.add(ChangeField.formatLabel(a.getLabel(), a.getValue()));
            }
            allApprovals.addAll(distinctApprovals);
            return allApprovals;
        }
    };
    public static final FieldDef<ChangeData, String> REVIEWED = new FieldDef.Single<ChangeData, String>("reviewed", FieldType.EXACT, false){

        @Override
        public String get(ChangeData input, FieldDef.FillArgs args) throws OrmException {
            for (PatchSetApproval a : input.currentApprovals()) {
                if (a.getValue() == 0) continue;
                return "1";
            }
            return null;
        }
    };
    public static final ChangeProtoField CHANGE = new ChangeProtoField();
    public static final PatchSetApprovalProtoField APPROVAL = new PatchSetApprovalProtoField();
    public static final FieldDef<ChangeData, String> COMMIT_MESSAGE = new FieldDef.Single<ChangeData, String>("message", FieldType.FULL_TEXT, false){

        @Override
        public String get(ChangeData input, FieldDef.FillArgs args) throws OrmException {
            try {
                return input.commitMessage();
            }
            catch (NoSuchChangeException | IOException e) {
                throw new OrmException(e);
            }
        }
    };
    public static final FieldDef<ChangeData, Iterable<String>> COMMENT = new FieldDef.Repeatable<ChangeData, String>("comment", FieldType.FULL_TEXT, false){

        @Override
        public Iterable<String> get(ChangeData input, FieldDef.FillArgs args) throws OrmException {
            HashSet<String> r = Sets.newHashSet();
            for (PatchLineComment c : input.comments()) {
                r.add(c.getMessage());
            }
            for (ChangeMessage m : input.messages()) {
                r.add(m.getMessage());
            }
            return r;
        }
    };
    public static final FieldDef<ChangeData, String> MERGEABLE = new FieldDef.Single<ChangeData, String>("mergeable", FieldType.EXACT, false){

        @Override
        public String get(ChangeData input, FieldDef.FillArgs args) throws OrmException {
            return input.change().isMergeable() ? "1" : null;
        }
    };
    public static final FieldDef<ChangeData, Integer> ADDED = new FieldDef.Single<ChangeData, Integer>("added", FieldType.INTEGER_RANGE, true){

        @Override
        public Integer get(ChangeData input, FieldDef.FillArgs args) throws OrmException {
            return input.changedLines().insertions;
        }
    };
    public static final FieldDef<ChangeData, Integer> DELETED = new FieldDef.Single<ChangeData, Integer>("deleted", FieldType.INTEGER_RANGE, true){

        @Override
        public Integer get(ChangeData input, FieldDef.FillArgs args) throws OrmException {
            return input.changedLines().deletions;
        }
    };
    public static final FieldDef<ChangeData, Integer> DELTA = new FieldDef.Single<ChangeData, Integer>("delta", FieldType.INTEGER_RANGE, false){

        @Override
        public Integer get(ChangeData input, FieldDef.FillArgs args) throws OrmException {
            ChangeData.ChangedLines changedLines = input.changedLines();
            return changedLines.insertions + changedLines.deletions;
        }
    };

    @Deprecated
    public static long legacyParseSortKey(String sortKey) {
        if ("z".equals(sortKey)) {
            return Long.MAX_VALUE;
        }
        return Long.parseLong(sortKey.substring(0, 8), 16);
    }

    public static Set<String> getFileParts(ChangeData cd) throws OrmException {
        Splitter s = Splitter.on('/').omitEmptyStrings();
        HashSet<String> r = Sets.newHashSet();
        for (String path : cd.currentFilePaths()) {
            for (String part : s.split(path)) {
                r.add(part);
            }
        }
        return r;
    }

    public static String formatLabel(String label, int value) {
        return ChangeField.formatLabel(label, value, null);
    }

    public static String formatLabel(String label, int value, Account.Id accountId) {
        return label.toLowerCase() + (value >= 0 ? "+" : "") + value + (accountId != null ? "," + accountId.get() : "");
    }

    private static <T> List<byte[]> toProtos(ProtobufCodec<T> codec, Collection<T> objs) throws OrmException {
        ArrayList<byte[]> result = Lists.newArrayListWithCapacity(objs.size());
        ByteArrayOutputStream out = new ByteArrayOutputStream(256);
        try {
            for (T obj : objs) {
                out.reset();
                CodedOutputStream cos = CodedOutputStream.newInstance(out);
                codec.encode(obj, cos);
                cos.flush();
                result.add(out.toByteArray());
            }
        }
        catch (IOException e) {
            throw new OrmException(e);
        }
        return result;
    }

    public static class PatchSetApprovalProtoField
    extends FieldDef.Repeatable<ChangeData, byte[]> {
        public static final ProtobufCodec<PatchSetApproval> CODEC = CodecFactory.encoder(PatchSetApproval.class);

        private PatchSetApprovalProtoField() {
            super("_approval", FieldType.STORED_ONLY, true);
        }

        @Override
        public Iterable<byte[]> get(ChangeData input, FieldDef.FillArgs args) throws OrmException {
            return ChangeField.toProtos(PatchSetApprovalProtoField.CODEC, input.currentApprovals());
        }
    }

    public static class ChangeProtoField
    extends FieldDef.Single<ChangeData, byte[]> {
        public static final ProtobufCodec<Change> CODEC = CodecFactory.encoder(Change.class);

        private ChangeProtoField() {
            super("_change", FieldType.STORED_ONLY, true);
        }

        @Override
        public byte[] get(ChangeData input, FieldDef.FillArgs args) throws OrmException {
            return CODEC.encodeToByteArray(input.change());
        }
    }
}

