/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gerrit.lifecycle.LifecycleModule;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.server.index.ChangeIndexer;
import com.google.gerrit.server.index.IndexCollection;
import com.google.gerrit.server.index.IndexExecutor;
import com.google.gerrit.server.index.IndexRewriteImpl;
import com.google.gerrit.server.query.change.BasicChangeRewrites;
import com.google.gerrit.server.query.change.ChangeQueryRewriter;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import org.eclipse.jgit.lib.Config;

public class IndexModule
extends LifecycleModule {
    private final int threads;
    private final ListeningExecutorService indexExecutor;

    public static IndexType getIndexType(Injector injector) {
        Config cfg = injector.getInstance(Key.get(Config.class, GerritServerConfig.class));
        return cfg.getEnum("index", null, "type", IndexType.LUCENE);
    }

    public IndexModule(int threads) {
        this.threads = threads;
        this.indexExecutor = null;
    }

    public IndexModule(ListeningExecutorService indexExecutor) {
        this.threads = -1;
        this.indexExecutor = indexExecutor;
    }

    @Override
    protected void configure() {
        this.bind(ChangeQueryRewriter.class).to(IndexRewriteImpl.class);
        this.bind(BasicChangeRewrites.class);
        this.bind(IndexCollection.class);
        this.listener().to(IndexCollection.class);
        this.factory(ChangeIndexer.Factory.class);
        if (this.indexExecutor != null) {
            this.bind(ListeningExecutorService.class).annotatedWith(IndexExecutor.class).toInstance(this.indexExecutor);
        } else {
            this.install(new IndexExecutorModule(this.threads));
        }
    }

    @Provides
    ChangeIndexer getChangeIndexer(ChangeIndexer.Factory factory, IndexCollection indexes) {
        return factory.create(indexes);
    }

    private static class IndexExecutorModule
    extends AbstractModule {
        private final int threads;

        private IndexExecutorModule(int threads) {
            this.threads = threads;
        }

        @Override
        public void configure() {
        }

        @Provides
        @Singleton
        @IndexExecutor
        ListeningExecutorService getIndexExecutor(@GerritServerConfig Config config, WorkQueue workQueue) {
            int threads = this.threads;
            if (threads <= 0) {
                threads = config.getInt("index", null, "threads", 0);
            }
            if (threads <= 0) {
                return MoreExecutors.sameThreadExecutor();
            }
            return MoreExecutors.listeningDecorator(workQueue.createQueue(threads, "index"));
        }
    }

    public static enum IndexType {
        LUCENE,
        SOLR;

    }
}

