/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gerrit.server.index.ChangeField;
import com.google.gerrit.server.index.ChangeIndex;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.QueryParseException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeDataSource;
import com.google.gerrit.server.query.change.Paginated;
import com.google.gerrit.server.query.change.SortKeyPredicate;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class IndexedChangeQuery
extends Predicate<ChangeData>
implements ChangeDataSource,
Paginated {
    private final ChangeIndex index;
    private final int limit;
    private Predicate<ChangeData> pred;
    private ChangeDataSource source;

    @VisibleForTesting
    static Predicate<ChangeData> replaceSortKeyPredicates(Predicate<ChangeData> p, String newValue) {
        if (p instanceof SortKeyPredicate) {
            return ((SortKeyPredicate)p).copy(newValue);
        }
        if (p.getChildCount() > 0) {
            ArrayList<Predicate<ChangeData>> newChildren = Lists.newArrayListWithCapacity(p.getChildCount());
            boolean replaced = false;
            for (Predicate<ChangeData> c : p.getChildren()) {
                Predicate<ChangeData> nc = IndexedChangeQuery.replaceSortKeyPredicates(c, newValue);
                newChildren.add(nc);
                if (nc == c) continue;
                replaced = true;
            }
            return replaced ? p.copy(newChildren) : p;
        }
        return p;
    }

    public IndexedChangeQuery(ChangeIndex index, Predicate<ChangeData> pred, int limit) throws QueryParseException {
        this.index = index;
        this.limit = limit;
        this.pred = pred;
        this.source = index.getSource(pred, 0, limit);
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    public Predicate<ChangeData> getChild(int i) {
        if (i == 0) {
            return this.pred;
        }
        throw new ArrayIndexOutOfBoundsException(i);
    }

    @Override
    public List<Predicate<ChangeData>> getChildren() {
        return ImmutableList.of(this.pred);
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public int getCardinality() {
        return this.source != null ? this.source.getCardinality() : this.limit();
    }

    @Override
    public boolean hasChange() {
        return this.index.getSchema().getFields().containsKey(ChangeField.CHANGE.getName());
    }

    @Override
    public ResultSet<ChangeData> read() throws OrmException {
        final ChangeDataSource currSource = this.source;
        final ResultSet rs = currSource.read();
        return new ResultSet<ChangeData>(){

            @Override
            public Iterator<ChangeData> iterator() {
                return Iterables.transform(rs, new Function<ChangeData, ChangeData>(){

                    @Override
                    public ChangeData apply(ChangeData input) {
                        input.cacheFromSource(currSource);
                        return input;
                    }
                }).iterator();
            }

            @Override
            public List<ChangeData> toList() {
                List<ChangeData> r = rs.toList();
                for (ChangeData cd : r) {
                    cd.cacheFromSource(currSource);
                }
                return r;
            }

            @Override
            public void close() {
                rs.close();
            }
        };
    }

    @Override
    public ResultSet<ChangeData> restart(ChangeData last) throws OrmException {
        this.pred = IndexedChangeQuery.replaceSortKeyPredicates(this.pred, last.change().getSortKey());
        try {
            this.source = this.index.getSource(this.pred, 0, this.limit);
        }
        catch (QueryParseException e) {
            throw new OrmException(e);
        }
        return this.read();
    }

    @Override
    public ResultSet<ChangeData> restart(int start) throws OrmException {
        try {
            this.source = this.index.getSource(this.pred, start, this.limit);
        }
        catch (QueryParseException e) {
            throw new OrmException(e);
        }
        return this.read();
    }

    @Override
    public Predicate<ChangeData> copy(Collection<? extends Predicate<ChangeData>> children) {
        return this;
    }

    @Override
    public boolean match(ChangeData cd) throws OrmException {
        return this.source != null && cd.isFromSource(this.source) || this.pred.match(cd);
    }

    @Override
    public int getCost() {
        return 1;
    }

    @Override
    public int hashCode() {
        return this.pred.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        IndexedChangeQuery o = (IndexedChangeQuery)other;
        return this.pred.equals(o.pred) && this.limit == o.limit;
    }

    public String toString() {
        return Objects.toStringHelper("index").add("p", this.pred).add("limit", this.limit).toString();
    }
}

