/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.ioutil;

import com.google.gerrit.server.StringUtil;
import java.io.PrintWriter;

public class ColumnFormatter {
    private char columnSeparator;
    private boolean firstColumn;
    private final PrintWriter out;

    public ColumnFormatter(PrintWriter out, char columnSeparator) {
        this.out = out;
        this.columnSeparator = columnSeparator;
        this.firstColumn = true;
    }

    public void addColumn(String content) {
        if (!this.firstColumn) {
            this.out.print(this.columnSeparator);
        }
        this.out.print(StringUtil.escapeString(content));
        this.firstColumn = false;
    }

    public void finish() {
        this.nextLine();
        this.out.flush();
    }

    public void nextLine() {
        if (!this.firstColumn) {
            this.out.print('\n');
            this.firstColumn = true;
        }
    }
}

