/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail;

import com.google.common.collect.Iterables;
import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountProjectWatch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.mail.EmailArguments;
import com.google.gerrit.server.mail.NewChangeSender;
import com.google.gerrit.server.mail.ProjectWatch;
import com.google.gerrit.server.mail.RecipientType;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateChangeSender
extends NewChangeSender {
    private static final Logger log = LoggerFactory.getLogger(CreateChangeSender.class);

    @Inject
    public CreateChangeSender(EmailArguments ea, @Assisted Change c) {
        super(ea, c);
    }

    @Override
    protected void init() throws EmailException {
        super.init();
        if (this.change.getStatus() == Change.Status.NEW) {
            try {
                ProjectWatch.Watchers matching = this.getWatchers(AccountProjectWatch.NotifyType.NEW_CHANGES);
                for (Account.Id user : Iterables.concat(matching.to.accounts, matching.cc.accounts, matching.bcc.accounts)) {
                    if (!this.isOwnerOfProjectOrBranch(user)) continue;
                    this.add(RecipientType.TO, user);
                }
                this.add(RecipientType.TO, matching.to);
                this.add(RecipientType.CC, matching.cc);
                this.add(RecipientType.BCC, matching.bcc);
            }
            catch (OrmException err) {
                log.warn("Cannot notify watchers for new change", err);
            }
            this.includeWatchers(AccountProjectWatch.NotifyType.NEW_PATCHSETS);
        }
    }

    private boolean isOwnerOfProjectOrBranch(Account.Id user) {
        return this.projectState != null && this.projectState.controlFor(this.args.identifiedUserFactory.create(user)).controlForRef(this.change.getDest()).isOwner();
    }

    public static interface Factory {
        public CreateChangeSender create(Change var1);
    }
}

