/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail;

import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.mail.Address;
import com.google.gerrit.server.mail.EmailArguments;
import com.google.gerrit.server.mail.EmailTokenVerifier;
import com.google.gerrit.server.mail.OutgoingEmail;
import com.google.gerrit.server.mail.RecipientType;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;

public class RegisterNewEmailSender
extends OutgoingEmail {
    private final EmailTokenVerifier tokenVerifier;
    private final IdentifiedUser user;
    private final String addr;
    private String emailToken;

    @Inject
    public RegisterNewEmailSender(EmailArguments ea, EmailTokenVerifier etv, IdentifiedUser callingUser, @Assisted String address) {
        super(ea, "registernewemail");
        this.tokenVerifier = etv;
        this.user = callingUser;
        this.addr = address;
    }

    @Override
    protected void init() throws EmailException {
        super.init();
        this.setHeader("Subject", "[Gerrit Code Review] Email Verification");
        this.add(RecipientType.TO, new Address(this.addr));
    }

    @Override
    protected boolean shouldSendMessage() {
        return true;
    }

    @Override
    protected void format() throws EmailException {
        this.appendText(this.velocifyFile("RegisterNewEmail.vm"));
    }

    public String getUserNameEmail() {
        String name = this.user.getAccount().getFullName();
        String email = this.user.getAccount().getPreferredEmail();
        if (name != null && email != null) {
            return name + " <" + email + ">";
        }
        if (email != null) {
            return email;
        }
        if (name != null) {
            return name;
        }
        String username = this.user.getUserName();
        if (username != null) {
            return username;
        }
        return null;
    }

    public String getEmailRegistrationToken() {
        if (this.emailToken == null) {
            this.emailToken = this.tokenVerifier.encode(this.user.getAccountId(), this.addr);
        }
        return this.emailToken;
    }

    public static interface Factory {
        public RegisterNewEmailSender create(String var1);
    }
}

