/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Enums;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.common.primitives.Ints;
import com.google.gerrit.common.data.SubmitRecord;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.notedb.AbstractChangeNotes;
import com.google.gerrit.server.notedb.ChangeNoteUtil;
import com.google.gerrit.server.notedb.CommentsInNotesUtil;
import com.google.gerrit.server.notedb.ReviewerState;
import com.google.gerrit.server.util.LabelVote;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.revwalk.FooterKey;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.RawParseUtils;

public class ChangeNotes
extends AbstractChangeNotes<ChangeNotes> {
    private static final Ordering<PatchSetApproval> PSA_BY_TIME = Ordering.natural().onResultOf(new Function<PatchSetApproval, Timestamp>(){

        @Override
        public Timestamp apply(PatchSetApproval input) {
            return input.getGranted();
        }
    });
    public static final Ordering<ChangeMessage> MESSAGE_BY_TIME = Ordering.natural().onResultOf(new Function<ChangeMessage, Timestamp>(){

        @Override
        public Timestamp apply(ChangeMessage input) {
            return input.getWrittenOn();
        }
    });
    public static Comparator<PatchLineComment> PatchLineCommentComparator = new Comparator<PatchLineComment>(){

        @Override
        public int compare(PatchLineComment c1, PatchLineComment c2) {
            String filename1 = c1.getKey().getParentKey().get();
            String filename2 = c2.getKey().getParentKey().get();
            return ComparisonChain.start().compare((Comparable<?>)((Object)filename1), (Comparable<?>)((Object)filename2)).compare(c1.getLine(), c2.getLine()).compare(c1.getWrittenOn(), c2.getWrittenOn()).result();
        }
    };
    private ImmutableListMultimap<PatchSet.Id, PatchSetApproval> approvals;
    private ImmutableSetMultimap<ReviewerState, Account.Id> reviewers;
    private ImmutableList<SubmitRecord> submitRecords;
    private ImmutableListMultimap<PatchSet.Id, ChangeMessage> changeMessages;
    private ImmutableListMultimap<PatchSet.Id, PatchLineComment> commentsForBase;
    private ImmutableListMultimap<PatchSet.Id, PatchLineComment> commentsForPS;
    NoteMap noteMap;

    public static ConfigInvalidException parseException(Change.Id changeId, String fmt, Object ... args) {
        return new ConfigInvalidException("Change " + changeId + ": " + String.format(fmt, args));
    }

    public static Account.Id parseIdent(PersonIdent ident, Change.Id changeId) throws ConfigInvalidException {
        String email = ident.getEmailAddress();
        int at = email.indexOf(64);
        if (at >= 0) {
            String host = email.substring(at + 1, email.length());
            Integer id = Ints.tryParse(email.substring(0, at));
            if (id != null && host.equals("gerrit")) {
                return new Account.Id(id);
            }
        }
        throw ChangeNotes.parseException(changeId, "invalid identity, expected <id>@%s: %s", "gerrit", email);
    }

    @VisibleForTesting
    public ChangeNotes(GitRepositoryManager repoManager, Change change) {
        super(repoManager, change);
    }

    public ImmutableListMultimap<PatchSet.Id, PatchSetApproval> getApprovals() {
        return this.approvals;
    }

    public ImmutableSetMultimap<ReviewerState, Account.Id> getReviewers() {
        return this.reviewers;
    }

    public ImmutableList<SubmitRecord> getSubmitRecords() {
        return this.submitRecords;
    }

    public ImmutableListMultimap<PatchSet.Id, ChangeMessage> getChangeMessages() {
        return this.changeMessages;
    }

    public ImmutableListMultimap<PatchSet.Id, PatchLineComment> getBaseComments() {
        return this.commentsForBase;
    }

    public ImmutableListMultimap<PatchSet.Id, PatchLineComment> getPatchSetComments() {
        return this.commentsForPS;
    }

    NoteMap getNoteMap() {
        return this.noteMap;
    }

    @Override
    protected String getRefName() {
        return ChangeNoteUtil.changeRefName(this.getChangeId());
    }

    @Override
    protected void onLoad() throws IOException, ConfigInvalidException {
        ObjectId rev = this.getRevision();
        if (rev == null) {
            this.loadDefaults();
            return;
        }
        RevWalk walk = new RevWalk(this.reader);
        try {
            Change change = this.getChange();
            Parser parser = new Parser(change, rev, walk, this.repoManager);
            parser.parseAll();
            if (parser.status != null) {
                change.setStatus(parser.status);
            }
            this.approvals = parser.buildApprovals();
            this.changeMessages = parser.buildMessages();
            this.commentsForBase = ImmutableListMultimap.copyOf(parser.commentsForBase);
            this.commentsForPS = ImmutableListMultimap.copyOf(parser.commentsForPs);
            this.noteMap = parser.commentNoteMap;
            ImmutableSetMultimap.Builder reviewers = ImmutableSetMultimap.builder();
            for (Map.Entry e : parser.reviewers.entrySet()) {
                reviewers.put(e.getValue(), e.getKey());
            }
            this.reviewers = reviewers.build();
            this.submitRecords = ImmutableList.copyOf(parser.submitRecords);
        }
        catch (ParseException e1) {
            throw new IOException(e1);
        }
        finally {
            walk.release();
        }
    }

    private void loadDefaults() {
        this.approvals = ImmutableListMultimap.of();
        this.reviewers = ImmutableSetMultimap.of();
        this.submitRecords = ImmutableList.of();
        this.changeMessages = ImmutableListMultimap.of();
        this.commentsForBase = ImmutableListMultimap.of();
        this.commentsForPS = ImmutableListMultimap.of();
    }

    @Override
    protected boolean onSave(CommitBuilder commit) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " is read-only");
    }

    private static Project.NameKey getProjectName(Change change) {
        return change.getProject();
    }

    @Override
    protected Project.NameKey getProjectName() {
        return ChangeNotes.getProjectName(this.getChange());
    }

    private static class Parser {
        private final Change.Id changeId;
        private final ObjectId tip;
        private final RevWalk walk;
        private final Repository repo;
        private final Map<PatchSet.Id, Table<Account.Id, String, Optional<PatchSetApproval>>> approvals;
        private final Map<Account.Id, ReviewerState> reviewers;
        private final List<SubmitRecord> submitRecords;
        private final Multimap<PatchSet.Id, ChangeMessage> changeMessages;
        private final Multimap<PatchSet.Id, PatchLineComment> commentsForPs;
        private final Multimap<PatchSet.Id, PatchLineComment> commentsForBase;
        private NoteMap commentNoteMap;
        private Change.Status status;

        private Parser(Change change, ObjectId tip, RevWalk walk, GitRepositoryManager repoManager) throws RepositoryNotFoundException, IOException {
            this.changeId = change.getId();
            this.tip = tip;
            this.walk = walk;
            this.repo = repoManager.openRepository(ChangeNotes.getProjectName(change));
            this.approvals = Maps.newHashMap();
            this.reviewers = Maps.newLinkedHashMap();
            this.submitRecords = Lists.newArrayListWithExpectedSize(1);
            this.changeMessages = LinkedListMultimap.create();
            this.commentsForPs = ArrayListMultimap.create();
            this.commentsForBase = ArrayListMultimap.create();
        }

        private void parseAll() throws ConfigInvalidException, IOException, ParseException {
            this.walk.markStart(this.walk.parseCommit(this.tip));
            for (RevCommit commit : this.walk) {
                this.parse(commit);
            }
            this.parseComments();
            this.pruneReviewers();
        }

        private ImmutableListMultimap<PatchSet.Id, PatchSetApproval> buildApprovals() {
            ArrayListMultimap<PatchSet.Id, PatchSetApproval> result = ArrayListMultimap.create(this.approvals.keySet().size(), 3);
            for (Table<Account.Id, String, Optional<PatchSetApproval>> table : this.approvals.values()) {
                for (PatchSetApproval psa : Optional.presentInstances(table.values())) {
                    result.put(psa.getPatchSetId(), psa);
                }
            }
            for (Collection collection : result.asMap().values()) {
                Collections.sort((List)collection, PSA_BY_TIME);
            }
            return ImmutableListMultimap.copyOf(result);
        }

        private ImmutableListMultimap<PatchSet.Id, ChangeMessage> buildMessages() {
            for (Collection<ChangeMessage> v : this.changeMessages.asMap().values()) {
                Collections.sort((List)v, MESSAGE_BY_TIME);
            }
            return ImmutableListMultimap.copyOf(this.changeMessages);
        }

        private void parse(RevCommit commit) throws ConfigInvalidException, IOException {
            if (this.status == null) {
                this.status = this.parseStatus(commit);
            }
            PatchSet.Id psId = this.parsePatchSetId(commit);
            Account.Id accountId = this.parseIdent(commit);
            this.parseChangeMessage(psId, accountId, commit);
            if (this.submitRecords.isEmpty()) {
                this.parseSubmitRecords(commit.getFooterLines(ChangeNoteUtil.FOOTER_SUBMITTED_WITH));
            }
            for (String line : commit.getFooterLines(ChangeNoteUtil.FOOTER_LABEL)) {
                this.parseApproval(psId, accountId, commit, line);
            }
            for (ReviewerState state : ReviewerState.values()) {
                for (String line : commit.getFooterLines(state.getFooterKey())) {
                    this.parseReviewer(state, line);
                }
            }
        }

        private Change.Status parseStatus(RevCommit commit) throws ConfigInvalidException {
            List<String> statusLines = commit.getFooterLines(ChangeNoteUtil.FOOTER_STATUS);
            if (statusLines.isEmpty()) {
                return null;
            }
            if (statusLines.size() > 1) {
                throw this.expectedOneFooter(ChangeNoteUtil.FOOTER_STATUS, statusLines);
            }
            Optional<Change.Status> status = Enums.getIfPresent(Change.Status.class, statusLines.get(0).toUpperCase());
            if (!status.isPresent()) {
                throw this.invalidFooter(ChangeNoteUtil.FOOTER_STATUS, statusLines.get(0));
            }
            return status.get();
        }

        private PatchSet.Id parsePatchSetId(RevCommit commit) throws ConfigInvalidException {
            List<String> psIdLines = commit.getFooterLines(ChangeNoteUtil.FOOTER_PATCH_SET);
            if (psIdLines.size() != 1) {
                throw this.expectedOneFooter(ChangeNoteUtil.FOOTER_PATCH_SET, psIdLines);
            }
            Integer psId = Ints.tryParse(psIdLines.get(0));
            if (psId == null) {
                throw this.invalidFooter(ChangeNoteUtil.FOOTER_PATCH_SET, psIdLines.get(0));
            }
            return new PatchSet.Id(this.changeId, psId);
        }

        private void parseChangeMessage(PatchSet.Id psId, Account.Id accountId, RevCommit commit) {
            int changeMessageStart;
            byte[] raw = commit.getRawBuffer();
            int size = raw.length;
            Charset enc = RawParseUtils.parseEncoding(raw);
            int subjectStart = RawParseUtils.commitMessage(raw, 0);
            if (subjectStart < 0 || subjectStart >= size) {
                return;
            }
            int subjectEnd = RawParseUtils.endOfParagraph(raw, subjectStart);
            if (subjectEnd == size) {
                return;
            }
            if (raw[subjectEnd] == 10) {
                changeMessageStart = subjectEnd + 2;
            } else if (raw[subjectEnd] == 13) {
                changeMessageStart = subjectEnd + 4;
            } else {
                return;
            }
            int ptr = size - 1;
            int changeMessageEnd = -1;
            while (ptr > changeMessageStart && (ptr = RawParseUtils.prevLF(raw, ptr, '\r')) != -1) {
                if (raw[ptr] == 10) {
                    changeMessageEnd = ptr - 1;
                    break;
                }
                if (raw[ptr] != 13) continue;
                changeMessageEnd = ptr - 3;
                break;
            }
            if (ptr <= changeMessageStart) {
                return;
            }
            String changeMsgString = RawParseUtils.decode(enc, raw, changeMessageStart, changeMessageEnd + 1);
            ChangeMessage changeMessage = new ChangeMessage(new ChangeMessage.Key(psId.getParentKey(), commit.name()), accountId, new Timestamp(commit.getCommitterIdent().getWhen().getTime()), psId);
            changeMessage.setMessage(changeMsgString);
            this.changeMessages.put(psId, changeMessage);
        }

        private void parseComments() throws IOException, ConfigInvalidException, ParseException {
            this.commentNoteMap = CommentsInNotesUtil.parseCommentsFromNotes(this.repo, ChangeNoteUtil.changeRefName(this.changeId), this.walk, this.changeId, this.commentsForBase, this.commentsForPs, PatchLineComment.Status.PUBLISHED);
        }

        private void parseApproval(PatchSet.Id psId, Account.Id accountId, RevCommit commit, String line) throws ConfigInvalidException {
            Table<Account.Id, String, Optional<PatchSetApproval>> curr = this.approvals.get(psId);
            if (curr == null) {
                curr = Tables.newCustomTable(Maps.newHashMapWithExpectedSize(2), new Supplier<Map<String, Optional<PatchSetApproval>>>(){

                    @Override
                    public Map<String, Optional<PatchSetApproval>> get() {
                        return Maps.newLinkedHashMap();
                    }
                });
                this.approvals.put(psId, curr);
            }
            if (line.startsWith("-")) {
                String label = line.substring(1);
                if (!curr.contains(accountId, label)) {
                    curr.put(accountId, label, Optional.absent());
                }
            } else {
                LabelVote l;
                try {
                    l = LabelVote.parseWithEquals(line);
                }
                catch (IllegalArgumentException e) {
                    ConfigInvalidException pe = this.parseException("invalid %s: %s", ChangeNoteUtil.FOOTER_LABEL, line);
                    pe.initCause(e);
                    throw pe;
                }
                if (!curr.contains(accountId, l.getLabel())) {
                    curr.put(accountId, l.getLabel(), Optional.of(new PatchSetApproval(new PatchSetApproval.Key(psId, accountId, new PatchSetApproval.LabelId(l.getLabel())), l.getValue(), new Timestamp(commit.getCommitterIdent().getWhen().getTime()))));
                }
            }
        }

        private void parseSubmitRecords(List<String> lines) throws ConfigInvalidException {
            SubmitRecord rec = null;
            for (String line : lines) {
                int c = line.indexOf(": ");
                if (c < 0) {
                    rec = new SubmitRecord();
                    this.submitRecords.add(rec);
                    int s = line.indexOf(32);
                    String statusStr = s >= 0 ? line.substring(0, s) : line;
                    Optional<SubmitRecord.Status> status = Enums.getIfPresent(SubmitRecord.Status.class, statusStr);
                    this.checkFooter(status.isPresent(), ChangeNoteUtil.FOOTER_SUBMITTED_WITH, line);
                    rec.status = status.get();
                    if (s < 0) continue;
                    rec.errorMessage = line.substring(s);
                    continue;
                }
                this.checkFooter(rec != null, ChangeNoteUtil.FOOTER_SUBMITTED_WITH, line);
                SubmitRecord.Label label = new SubmitRecord.Label();
                if (rec.labels == null) {
                    rec.labels = Lists.newArrayList();
                }
                rec.labels.add(label);
                Optional<SubmitRecord.Label.Status> status = Enums.getIfPresent(SubmitRecord.Label.Status.class, line.substring(0, c));
                this.checkFooter(status.isPresent(), ChangeNoteUtil.FOOTER_SUBMITTED_WITH, line);
                label.status = status.get();
                int c2 = line.indexOf(": ", c + 2);
                if (c2 >= 0) {
                    label.label = line.substring(c + 2, c2);
                    PersonIdent ident = RawParseUtils.parsePersonIdent(line.substring(c2 + 2));
                    this.checkFooter(ident != null, ChangeNoteUtil.FOOTER_SUBMITTED_WITH, line);
                    label.appliedBy = this.parseIdent(ident);
                    continue;
                }
                label.label = line.substring(c + 2);
            }
        }

        private Account.Id parseIdent(RevCommit commit) throws ConfigInvalidException {
            return this.parseIdent(commit.getAuthorIdent());
        }

        private Account.Id parseIdent(PersonIdent ident) throws ConfigInvalidException {
            String email = ident.getEmailAddress();
            int at = email.indexOf(64);
            if (at >= 0) {
                String host = email.substring(at + 1, email.length());
                Integer id = Ints.tryParse(email.substring(0, at));
                if (id != null && host.equals("gerrit")) {
                    return new Account.Id(id);
                }
            }
            throw this.parseException("invalid identity, expected <id>@%s: %s", "gerrit", email);
        }

        private void parseReviewer(ReviewerState state, String line) throws ConfigInvalidException {
            PersonIdent ident = RawParseUtils.parsePersonIdent(line);
            if (ident == null) {
                throw this.invalidFooter(state.getFooterKey(), line);
            }
            Account.Id accountId = this.parseIdent(ident);
            if (!this.reviewers.containsKey(accountId)) {
                this.reviewers.put(accountId, state);
            }
        }

        private void pruneReviewers() {
            Iterator<Map.Entry<Account.Id, ReviewerState>> rit = this.reviewers.entrySet().iterator();
            while (rit.hasNext()) {
                Map.Entry<Account.Id, ReviewerState> e = rit.next();
                if (e.getValue() != ReviewerState.REMOVED) continue;
                rit.remove();
                for (Table<Account.Id, String, Optional<PatchSetApproval>> curr : this.approvals.values()) {
                    curr.rowKeySet().remove(e.getKey());
                }
            }
        }

        private ConfigInvalidException expectedOneFooter(FooterKey footer, List<String> actual) {
            return this.parseException("missing or multiple %s: %s", footer.getName(), actual);
        }

        private ConfigInvalidException invalidFooter(FooterKey footer, String actual) {
            return this.parseException("invalid %s: %s", footer.getName(), actual);
        }

        private void checkFooter(boolean expr, FooterKey footer, String actual) throws ConfigInvalidException {
            if (!expr) {
                throw this.invalidFooter(footer, actual);
            }
        }

        private ConfigInvalidException parseException(String fmt, Object ... args) {
            return ChangeNotes.parseException(this.changeId, fmt, args);
        }
    }

    @Singleton
    public static class Factory {
        private final GitRepositoryManager repoManager;

        @Inject
        @VisibleForTesting
        public Factory(GitRepositoryManager repoManager) {
            this.repoManager = repoManager;
        }

        public ChangeNotes create(Change change) {
            return new ChangeNotes(this.repoManager, change);
        }
    }
}

