/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.gerrit.server.plugins.PluginLoader;
import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;

class CleanupHandle {
    private final File tmpFile;
    private final JarFile jarFile;

    CleanupHandle(File tmpFile, JarFile jarFile) {
        this.tmpFile = tmpFile;
        this.jarFile = jarFile;
    }

    void cleanup() {
        try {
            this.jarFile.close();
        }
        catch (IOException err) {
            PluginLoader.log.error("Cannot close " + this.jarFile.getName(), err);
        }
        if (!this.tmpFile.delete() && this.tmpFile.exists()) {
            PluginLoader.log.warn("Cannot delete " + this.tmpFile.getAbsolutePath() + ", retrying to delete it on termination of the virtual machine");
            this.tmpFile.deleteOnExit();
        } else {
            PluginLoader.log.info("Cleaned plugin " + this.tmpFile.getName());
        }
    }
}

