/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.common.collect.ImmutableSet;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.server.plugins.ListPlugins;
import com.google.gerrit.server.plugins.PluginLoader;
import com.google.gerrit.server.plugins.PluginResource;
import com.google.inject.Inject;
import com.google.inject.Singleton;

@RequiresCapability(value="administrateServer")
@Singleton
class DisablePlugin
implements RestModifyView<PluginResource, Input> {
    private final PluginLoader loader;

    @Inject
    DisablePlugin(PluginLoader loader) {
        this.loader = loader;
    }

    public ListPlugins.PluginInfo apply(PluginResource resource, Input input) throws MethodNotAllowedException {
        if (!this.loader.isRemoteAdminEnabled()) {
            throw new MethodNotAllowedException("remote plugin administration is disabled");
        }
        String name = resource.getName();
        this.loader.disablePlugins(ImmutableSet.of(name));
        return new ListPlugins.PluginInfo(this.loader.get(name));
    }

    static class Input {
        Input() {
        }
    }
}

