/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.common.base.Objects;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.plugins.CleanupHandle;
import com.google.gerrit.server.plugins.InvalidPluginException;
import com.google.gerrit.server.plugins.JarScanner;
import com.google.gerrit.server.plugins.Plugin;
import com.google.gerrit.server.plugins.PluginLoader;
import com.google.gerrit.server.plugins.ServerPlugin;
import com.google.gerrit.server.plugins.ServerPluginProvider;
import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarPluginProvider
implements ServerPluginProvider {
    static final String PLUGIN_TMP_PREFIX = "plugin_";
    static final String JAR_EXTENSION = ".jar";
    static final Logger log = LoggerFactory.getLogger(JarPluginProvider.class);
    private final File tmpDir;

    @Inject
    JarPluginProvider(SitePaths sitePaths) {
        this.tmpDir = sitePaths.tmp_dir;
    }

    @Override
    public boolean handles(File srcFile) {
        String fileName = srcFile.getName();
        return fileName.endsWith(JAR_EXTENSION) || fileName.endsWith(".jar.disabled");
    }

    @Override
    public String getPluginName(File srcFile) {
        try {
            return Objects.firstNonNull(JarPluginProvider.getJarPluginName(srcFile), PluginLoader.nameOf(srcFile));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid plugin file " + srcFile + ": cannot get plugin name", e);
        }
    }

    public static String getJarPluginName(File srcFile) throws IOException {
        try (JarFile jarFile = new JarFile(srcFile);){
            String string = jarFile.getManifest().getMainAttributes().getValue("Gerrit-PluginName");
            return string;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ServerPlugin get(File srcFile, FileSnapshot snapshot, ServerPluginProvider.PluginDescription description) throws InvalidPluginException {
        try {
            String name = this.getPluginName(srcFile);
            String extension = JarPluginProvider.getExtension(srcFile);
            try (FileInputStream in = new FileInputStream(srcFile);){
                File tmp = PluginLoader.asTemp(in, JarPluginProvider.tempNameFor(name), extension, this.tmpDir);
                ServerPlugin serverPlugin = this.loadJarPlugin(name, srcFile, snapshot, tmp, description);
                return serverPlugin;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new InvalidPluginException("Cannot load Jar plugin " + srcFile, e);
        }
    }

    @Override
    public String getProviderPluginName() {
        return "gerrit";
    }

    private static String getExtension(File file) {
        return JarPluginProvider.getExtension(file.getName());
    }

    private static String getExtension(String name) {
        int ext = name.lastIndexOf(46);
        return 0 < ext ? name.substring(ext) : "";
    }

    private static String tempNameFor(String name) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyMMdd_HHmm");
        return PLUGIN_TMP_PREFIX + name + "_" + fmt.format(new Date()) + "_";
    }

    public static File storeInTemp(String pluginName, InputStream in, SitePaths sitePaths) throws IOException {
        if (!sitePaths.tmp_dir.exists()) {
            sitePaths.tmp_dir.mkdirs();
        }
        return PluginLoader.asTemp(in, JarPluginProvider.tempNameFor(pluginName), JAR_EXTENSION, sitePaths.tmp_dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerPlugin loadJarPlugin(String name, File srcJar, FileSnapshot snapshot, File tmp, ServerPluginProvider.PluginDescription description) throws IOException, InvalidPluginException, MalformedURLException, ClassNotFoundException {
        JarFile jarFile = new JarFile(tmp);
        boolean keep = false;
        try {
            File classes;
            Manifest manifest = jarFile.getManifest();
            Plugin.ApiType type = Plugin.getApiType(manifest);
            ArrayList<URL> urls = new ArrayList<URL>(2);
            String overlay = System.getProperty("gerrit.plugin-classes");
            if (overlay != null && (classes = new File(new File(new File(overlay), name), "main")).isDirectory()) {
                log.info(String.format("plugin %s: including %s", name, classes.getPath()));
                urls.add(classes.toURI().toURL());
            }
            urls.add(tmp.toURI().toURL());
            URLClassLoader pluginLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), PluginLoader.parentFor(type));
            ServerPlugin plugin = new ServerPlugin(name, description.canonicalUrl, description.user, srcJar, snapshot, new JarScanner(srcJar), description.dataDir, pluginLoader);
            plugin.setCleanupHandle(new CleanupHandle(tmp, jarFile));
            keep = true;
            ServerPlugin serverPlugin = plugin;
            return serverPlugin;
        }
        finally {
            if (!keep) {
                jarFile.close();
            }
        }
    }
}

