/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gerrit.server.plugins.InvalidPluginException;
import com.google.gerrit.server.plugins.PluginContentScanner;
import com.google.gerrit.server.plugins.PluginEntry;
import com.google.gerrit.server.plugins.PluginLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.jgit.util.IO;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class JarScanner
implements PluginContentScanner {
    private static final int SKIP_ALL = 7;
    private static final Function<ClassData, PluginContentScanner.ExtensionMetaData> CLASS_DATA_TO_EXTENSION_META_DATA = new Function<ClassData, PluginContentScanner.ExtensionMetaData>(){

        @Override
        public PluginContentScanner.ExtensionMetaData apply(ClassData classData) {
            return new PluginContentScanner.ExtensionMetaData(classData.className, classData.annotationValue);
        }
    };
    private final JarFile jarFile;

    public JarScanner(File srcFile) throws InvalidPluginException {
        try {
            this.jarFile = new JarFile(srcFile);
        }
        catch (IOException e) {
            throw new InvalidPluginException("Cannot scan plugin file " + srcFile, e);
        }
    }

    @Override
    public Map<Class<? extends Annotation>, Iterable<PluginContentScanner.ExtensionMetaData>> scan(String pluginName, Iterable<Class<? extends Annotation>> annotations) throws InvalidPluginException {
        HashSet<String> descriptors = Sets.newHashSet();
        ArrayListMultimap<String, ClassData> rawMap = ArrayListMultimap.create();
        HashMap<Class<? extends Annotation>, String> classObjToClassDescr = Maps.newHashMap();
        for (Class<? extends Annotation> annotation : annotations) {
            String descriptor = Type.getType(annotation).getDescriptor();
            descriptors.add(descriptor);
            classObjToClassDescr.put(annotation, descriptor);
        }
        Enumeration<JarEntry> e = this.jarFile.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            if (JarScanner.skip(entry)) continue;
            ClassData def = new ClassData(descriptors);
            try {
                new ClassReader(JarScanner.read(this.jarFile, entry)).accept(def, 7);
            }
            catch (IOException err) {
                throw new InvalidPluginException("Cannot auto-register", err);
            }
            catch (RuntimeException err) {
                PluginLoader.log.warn(String.format("Plugin %s has invaild class file %s inside of %s", pluginName, entry.getName(), this.jarFile.getName()), err);
                continue;
            }
            if (def.isConcrete()) {
                if (Strings.isNullOrEmpty(def.annotationName)) continue;
                rawMap.put(def.annotationName, def);
                continue;
            }
            PluginLoader.log.warn(String.format("Plugin %s tries to @%s(\"%s\") abstract class %s", pluginName, def.annotationName, def.annotationValue, def.className));
        }
        ImmutableMap.Builder<Class<? extends Annotation>, Iterable<PluginContentScanner.ExtensionMetaData>> result = ImmutableMap.builder();
        for (Class<? extends Annotation> annotoation : annotations) {
            String descr = (String)classObjToClassDescr.get(annotoation);
            Collection discoverdData = rawMap.get(descr);
            Collection values = Objects.firstNonNull(discoverdData, Collections.emptySet());
            result.put(annotoation, Iterables.transform(values, CLASS_DATA_TO_EXTENSION_META_DATA));
        }
        return result.build();
    }

    private static boolean skip(JarEntry entry) {
        if (!entry.getName().endsWith(".class")) {
            return true;
        }
        if (entry.getSize() <= 0L) {
            return true;
        }
        return entry.getSize() >= 0x100000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] read(JarFile jarFile, JarEntry entry) throws IOException {
        byte[] data = new byte[(int)entry.getSize()];
        try (InputStream in = jarFile.getInputStream(entry);){
            IO.readFully(in, data, 0, data.length);
        }
        return data;
    }

    @Override
    public Optional<PluginEntry> getEntry(String resourcePath) throws IOException {
        JarEntry jarEntry = this.jarFile.getJarEntry(resourcePath);
        if (jarEntry == null || jarEntry.getSize() == 0L) {
            return Optional.absent();
        }
        return Optional.of(this.resourceOf(jarEntry));
    }

    @Override
    public Enumeration<PluginEntry> entries() {
        return Collections.enumeration(Lists.transform(Collections.list(this.jarFile.entries()), new Function<JarEntry, PluginEntry>(){

            @Override
            public PluginEntry apply(JarEntry jarEntry) {
                try {
                    return JarScanner.this.resourceOf(jarEntry);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Cannot convert jar entry " + jarEntry + " to a resource", e);
                }
            }
        }));
    }

    @Override
    public InputStream getInputStream(PluginEntry entry) throws IOException {
        return this.jarFile.getInputStream(this.jarFile.getEntry(entry.getName()));
    }

    @Override
    public Manifest getManifest() throws IOException {
        return this.jarFile.getManifest();
    }

    private PluginEntry resourceOf(JarEntry jarEntry) throws IOException {
        return new PluginEntry(jarEntry.getName(), jarEntry.getTime(), Optional.of(jarEntry.getSize()), this.attributesOf(jarEntry));
    }

    private Map<Object, String> attributesOf(JarEntry jarEntry) throws IOException {
        Attributes attributes = jarEntry.getAttributes();
        if (attributes == null) {
            return Collections.emptyMap();
        }
        return Maps.transformEntries(attributes, new Maps.EntryTransformer<Object, Object, String>(){

            @Override
            public String transformEntry(Object key, Object value) {
                return (String)value;
            }
        });
    }

    private static abstract class AbstractAnnotationVisitor
    extends AnnotationVisitor {
        AbstractAnnotationVisitor() {
            super(262144);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String arg0, String arg1) {
            return null;
        }

        @Override
        public AnnotationVisitor visitArray(String arg0) {
            return null;
        }

        @Override
        public void visitEnum(String arg0, String arg1, String arg2) {
        }

        @Override
        public void visitEnd() {
        }
    }

    public static class ClassData
    extends ClassVisitor {
        int access;
        String className;
        String annotationName;
        String annotationValue;
        Iterable<String> exports;

        private ClassData(Iterable<String> exports) {
            super(262144);
            this.exports = exports;
        }

        boolean isConcrete() {
            return (this.access & 0x400) == 0 && (this.access & 0x200) == 0;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.className = Type.getObjectType(name).getClassName();
            this.access = access;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            Optional<String> found = Iterables.tryFind(this.exports, Predicates.equalTo(desc));
            if (visible && found.isPresent()) {
                this.annotationName = desc;
                return new AbstractAnnotationVisitor(){

                    @Override
                    public void visit(String name, Object value) {
                        ClassData.this.annotationValue = (String)value;
                    }
                };
            }
            return null;
        }

        @Override
        public void visitSource(String arg0, String arg1) {
        }

        @Override
        public void visitOuterClass(String arg0, String arg1, String arg2) {
        }

        @Override
        public MethodVisitor visitMethod(int arg0, String arg1, String arg2, String arg3, String[] arg4) {
            return null;
        }

        @Override
        public void visitInnerClass(String arg0, String arg1, String arg2, int arg3) {
        }

        @Override
        public FieldVisitor visitField(int arg0, String arg1, String arg2, String arg3, Object arg4) {
            return null;
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void visitAttribute(Attribute arg0) {
        }
    }
}

