/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.annotations.RootRelative;
import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.registration.PrivateInternals_DynamicMapImpl;
import com.google.gerrit.extensions.registration.PrivateInternals_DynamicTypes;
import com.google.gerrit.extensions.registration.RegistrationHandle;
import com.google.gerrit.extensions.registration.ReloadableRegistrationHandle;
import com.google.gerrit.extensions.systemstatus.ServerInformation;
import com.google.gerrit.server.plugins.CopyConfigModule;
import com.google.gerrit.server.plugins.ModuleGenerator;
import com.google.gerrit.server.plugins.Plugin;
import com.google.gerrit.server.plugins.ReloadPluginListener;
import com.google.gerrit.server.plugins.StartPluginListener;
import com.google.gerrit.server.plugins.StopPluginListener;
import com.google.gerrit.server.util.PluginRequestContext;
import com.google.gerrit.server.util.RequestContext;
import com.google.gerrit.server.util.ThreadLocalRequestContext;
import com.google.inject.AbstractModule;
import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.UniqueAnnotations;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Singleton
public class PluginGuiceEnvironment {
    private final Injector sysInjector;
    private final ServerInformation srvInfo;
    private final ThreadLocalRequestContext local;
    private final CopyConfigModule copyConfigModule;
    private final Set<Key<?>> copyConfigKeys;
    private final List<StartPluginListener> onStart;
    private final List<StopPluginListener> onStop;
    private final List<ReloadPluginListener> onReload;
    private Module sysModule;
    private Module sshModule;
    private Module httpModule;
    private Provider<ModuleGenerator> sshGen;
    private Provider<ModuleGenerator> httpGen;
    private Map<TypeLiteral<?>, DynamicItem<?>> sysItems;
    private Map<TypeLiteral<?>, DynamicItem<?>> sshItems;
    private Map<TypeLiteral<?>, DynamicItem<?>> httpItems;
    private Map<TypeLiteral<?>, DynamicSet<?>> sysSets;
    private Map<TypeLiteral<?>, DynamicSet<?>> sshSets;
    private Map<TypeLiteral<?>, DynamicSet<?>> httpSets;
    private Map<TypeLiteral<?>, DynamicMap<?>> sysMaps;
    private Map<TypeLiteral<?>, DynamicMap<?>> sshMaps;
    private Map<TypeLiteral<?>, DynamicMap<?>> httpMaps;
    private static final Class<?> UNIQUE_ANNOTATION = UniqueAnnotations.create().getClass();

    @Inject
    PluginGuiceEnvironment(Injector sysInjector, ThreadLocalRequestContext local, ServerInformation srvInfo, CopyConfigModule ccm) {
        this.sysInjector = sysInjector;
        this.srvInfo = srvInfo;
        this.local = local;
        this.copyConfigModule = ccm;
        this.copyConfigKeys = Guice.createInjector(ccm).getAllBindings().keySet();
        this.onStart = new CopyOnWriteArrayList<StartPluginListener>();
        this.onStart.addAll(PluginGuiceEnvironment.listeners(sysInjector, StartPluginListener.class));
        this.onStop = new CopyOnWriteArrayList<StopPluginListener>();
        this.onStop.addAll(PluginGuiceEnvironment.listeners(sysInjector, StopPluginListener.class));
        this.onReload = new CopyOnWriteArrayList<ReloadPluginListener>();
        this.onReload.addAll(PluginGuiceEnvironment.listeners(sysInjector, ReloadPluginListener.class));
        this.sysItems = PrivateInternals_DynamicTypes.dynamicItemsOf(sysInjector);
        this.sysSets = PrivateInternals_DynamicTypes.dynamicSetsOf(sysInjector);
        this.sysMaps = PrivateInternals_DynamicTypes.dynamicMapsOf(sysInjector);
    }

    ServerInformation getServerInformation() {
        return this.srvInfo;
    }

    boolean hasDynamicItem(TypeLiteral<?> type) {
        return this.sysItems.containsKey(type) || this.sshItems != null && this.sshItems.containsKey(type) || this.httpItems != null && this.httpItems.containsKey(type);
    }

    boolean hasDynamicSet(TypeLiteral<?> type) {
        return this.sysSets.containsKey(type) || this.sshSets != null && this.sshSets.containsKey(type) || this.httpSets != null && this.httpSets.containsKey(type);
    }

    boolean hasDynamicMap(TypeLiteral<?> type) {
        return this.sysMaps.containsKey(type) || this.sshMaps != null && this.sshMaps.containsKey(type) || this.httpMaps != null && this.httpMaps.containsKey(type);
    }

    Module getSysModule() {
        return this.sysModule;
    }

    public void setCfgInjector(Injector cfgInjector) {
        final Module cm = this.copy(cfgInjector);
        final Module sm = this.copy(this.sysInjector);
        this.sysModule = new AbstractModule(){

            @Override
            protected void configure() {
                this.install(PluginGuiceEnvironment.this.copyConfigModule);
                this.install(cm);
                this.install(sm);
            }
        };
    }

    public void setSshInjector(Injector injector) {
        this.sshModule = this.copy(injector);
        this.sshGen = injector.getProvider(ModuleGenerator.class);
        this.sshItems = PrivateInternals_DynamicTypes.dynamicItemsOf(injector);
        this.sshSets = PrivateInternals_DynamicTypes.dynamicSetsOf(injector);
        this.sshMaps = PrivateInternals_DynamicTypes.dynamicMapsOf(injector);
        this.onStart.addAll(PluginGuiceEnvironment.listeners(injector, StartPluginListener.class));
        this.onStop.addAll(PluginGuiceEnvironment.listeners(injector, StopPluginListener.class));
        this.onReload.addAll(PluginGuiceEnvironment.listeners(injector, ReloadPluginListener.class));
    }

    boolean hasSshModule() {
        return this.sshModule != null;
    }

    Module getSshModule() {
        return this.sshModule;
    }

    ModuleGenerator newSshModuleGenerator() {
        return this.sshGen.get();
    }

    public void setHttpInjector(Injector injector) {
        this.httpModule = this.copy(injector);
        this.httpGen = injector.getProvider(ModuleGenerator.class);
        this.httpItems = PrivateInternals_DynamicTypes.dynamicItemsOf(injector);
        this.httpSets = PrivateInternals_DynamicTypes.dynamicSetsOf(injector);
        this.httpMaps = PrivateInternals_DynamicTypes.dynamicMapsOf(injector);
        this.onStart.addAll(PluginGuiceEnvironment.listeners(injector, StartPluginListener.class));
        this.onStop.addAll(PluginGuiceEnvironment.listeners(injector, StopPluginListener.class));
        this.onReload.addAll(PluginGuiceEnvironment.listeners(injector, ReloadPluginListener.class));
    }

    boolean hasHttpModule() {
        return this.httpModule != null;
    }

    Module getHttpModule() {
        return this.httpModule;
    }

    ModuleGenerator newHttpModuleGenerator() {
        return this.httpGen.get();
    }

    RequestContext enter(Plugin plugin) {
        return this.local.setContext(new PluginRequestContext(plugin.getPluginUser()));
    }

    void exit(RequestContext old) {
        this.local.setContext(old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onStartPlugin(Plugin plugin) {
        RequestContext oldContext = this.enter(plugin);
        try {
            this.attachItem(this.sysItems, plugin.getSysInjector(), plugin);
            this.attachItem(this.sshItems, plugin.getSshInjector(), plugin);
            this.attachItem(this.httpItems, plugin.getHttpInjector(), plugin);
            this.attachSet(this.sysSets, plugin.getSysInjector(), plugin);
            this.attachSet(this.sshSets, plugin.getSshInjector(), plugin);
            this.attachSet(this.httpSets, plugin.getHttpInjector(), plugin);
            this.attachMap(this.sysMaps, plugin.getSysInjector(), plugin);
            this.attachMap(this.sshMaps, plugin.getSshInjector(), plugin);
            this.attachMap(this.httpMaps, plugin.getHttpInjector(), plugin);
        }
        finally {
            this.exit(oldContext);
        }
        for (StartPluginListener l : this.onStart) {
            l.onStartPlugin(plugin);
        }
    }

    void onStopPlugin(Plugin plugin) {
        for (StopPluginListener l : this.onStop) {
            l.onStopPlugin(plugin);
        }
    }

    private void attachItem(Map<TypeLiteral<?>, DynamicItem<?>> items, @Nullable Injector src, Plugin plugin) {
        for (RegistrationHandle h : PrivateInternals_DynamicTypes.attachItems(src, items, plugin.getName())) {
            plugin.add(h);
        }
    }

    private void attachSet(Map<TypeLiteral<?>, DynamicSet<?>> sets, @Nullable Injector src, Plugin plugin) {
        for (RegistrationHandle h : PrivateInternals_DynamicTypes.attachSets(src, sets)) {
            plugin.add(h);
        }
    }

    private void attachMap(Map<TypeLiteral<?>, DynamicMap<?>> maps, @Nullable Injector src, Plugin plugin) {
        for (RegistrationHandle h : PrivateInternals_DynamicTypes.attachMaps(src, plugin.getName(), maps)) {
            plugin.add(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onReloadPlugin(Plugin oldPlugin, Plugin newPlugin) {
        LinkedListMultimap<TypeLiteral<?>, ReloadableRegistrationHandle<?>> old = LinkedListMultimap.create();
        for (ReloadableRegistrationHandle<?> h : oldPlugin.getReloadableHandles()) {
            old.put(h.getKey().getTypeLiteral(), h);
        }
        RequestContext oldContext = this.enter(newPlugin);
        try {
            this.reattachMap(old, this.sysMaps, newPlugin.getSysInjector(), newPlugin);
            this.reattachMap(old, this.sshMaps, newPlugin.getSshInjector(), newPlugin);
            this.reattachMap(old, this.httpMaps, newPlugin.getHttpInjector(), newPlugin);
            this.reattachSet(old, this.sysSets, newPlugin.getSysInjector(), newPlugin);
            this.reattachSet(old, this.sshSets, newPlugin.getSshInjector(), newPlugin);
            this.reattachSet(old, this.httpSets, newPlugin.getHttpInjector(), newPlugin);
            this.reattachItem(old, this.sysItems, newPlugin.getSysInjector(), newPlugin);
            this.reattachItem(old, this.sshItems, newPlugin.getSshInjector(), newPlugin);
            this.reattachItem(old, this.httpItems, newPlugin.getHttpInjector(), newPlugin);
        }
        finally {
            this.exit(oldContext);
        }
        for (ReloadPluginListener l : this.onReload) {
            l.onReloadPlugin(oldPlugin, newPlugin);
        }
    }

    private void reattachMap(ListMultimap<TypeLiteral<?>, ReloadableRegistrationHandle<?>> oldHandles, Map<TypeLiteral<?>, DynamicMap<?>> maps, @Nullable Injector src, Plugin newPlugin) {
        if (src == null || maps == null || maps.isEmpty()) {
            return;
        }
        for (Map.Entry<TypeLiteral<?>, DynamicMap<?>> e : maps.entrySet()) {
            TypeLiteral<?> type = e.getKey();
            PrivateInternals_DynamicMapImpl map = (PrivateInternals_DynamicMapImpl)e.getValue();
            HashMap<Annotation, ReloadableRegistrationHandle<?>> am = Maps.newHashMap();
            for (ReloadableRegistrationHandle<?> reloadableRegistrationHandle : oldHandles.get(type)) {
                Annotation a = reloadableRegistrationHandle.getKey().getAnnotation();
                if (a == null || UNIQUE_ANNOTATION.isInstance(a)) continue;
                am.put(a, reloadableRegistrationHandle);
            }
            for (Binding binding : PluginGuiceEnvironment.bindings(src, e.getKey())) {
                Binding b = binding;
                Key key = b.getKey();
                if (key.getAnnotation() == null) continue;
                ReloadableRegistrationHandle h = (ReloadableRegistrationHandle)am.remove(key.getAnnotation());
                if (h != null) {
                    PluginGuiceEnvironment.replace(newPlugin, h, b);
                    oldHandles.remove(type, h);
                    continue;
                }
                newPlugin.add(map.put(newPlugin.getName(), b.getKey(), b.getProvider()));
            }
        }
    }

    private void reattachSet(ListMultimap<TypeLiteral<?>, ReloadableRegistrationHandle<?>> oldHandles, Map<TypeLiteral<?>, DynamicSet<?>> sets, @Nullable Injector src, Plugin newPlugin) {
        if (src == null || sets == null || sets.isEmpty()) {
            return;
        }
        for (Map.Entry<TypeLiteral<?>, DynamicSet<?>> e : sets.entrySet()) {
            TypeLiteral<?> type = e.getKey();
            DynamicSet<?> set = e.getValue();
            HashMap<Annotation, ReloadableRegistrationHandle<?>> am = Maps.newHashMap();
            List<ReloadableRegistrationHandle<?>> old = oldHandles.get(type);
            Iterator<ReloadableRegistrationHandle<?>> oi = old.iterator();
            while (oi.hasNext()) {
                ReloadableRegistrationHandle<?> h = oi.next();
                Annotation a = h.getKey().getAnnotation();
                if (a == null || UNIQUE_ANNOTATION.isInstance(a)) continue;
                am.put(a, h);
                oi.remove();
            }
            oi = old.iterator();
            for (Binding<?> binding : PluginGuiceEnvironment.bindings(src, type)) {
                Binding<?> b = binding;
                Key<?> key = b.getKey();
                if (key.getAnnotation() == null) continue;
                ReloadableRegistrationHandle h1 = (ReloadableRegistrationHandle)am.remove(key.getAnnotation());
                if (h1 != null) {
                    PluginGuiceEnvironment.replace(newPlugin, h1, b);
                    continue;
                }
                if (oi.hasNext()) {
                    ReloadableRegistrationHandle<?> h2 = oi.next();
                    oi.remove();
                    PluginGuiceEnvironment.replace(newPlugin, h2, b);
                    continue;
                }
                newPlugin.add(set.add(b.getKey(), b.getProvider()));
            }
        }
    }

    private void reattachItem(ListMultimap<TypeLiteral<?>, ReloadableRegistrationHandle<?>> oldHandles, Map<TypeLiteral<?>, DynamicItem<?>> items, @Nullable Injector src, Plugin newPlugin) {
        if (src == null || items == null || items.isEmpty()) {
            return;
        }
        for (Map.Entry<TypeLiteral<?>, DynamicItem<?>> e : items.entrySet()) {
            TypeLiteral<?> type = e.getKey();
            DynamicItem<?> item = e.getValue();
            Iterator<ReloadableRegistrationHandle<?>> oi = oldHandles.get(type).iterator();
            Iterator<Binding<?>> i$ = PluginGuiceEnvironment.bindings(src, type).iterator();
            while (i$.hasNext()) {
                Binding<?> binding;
                Binding<?> b = binding = i$.next();
                if (oi.hasNext()) {
                    ReloadableRegistrationHandle<?> h = oi.next();
                    oi.remove();
                    PluginGuiceEnvironment.replace(newPlugin, h, b);
                    continue;
                }
                newPlugin.add(item.set(b.getKey(), b.getProvider(), newPlugin.getName()));
            }
        }
    }

    private static <T> void replace(Plugin newPlugin, ReloadableRegistrationHandle<T> h, Binding<T> b) {
        RegistrationHandle n = h.replace(b.getKey(), b.getProvider());
        if (n != null) {
            newPlugin.add(n);
        }
    }

    static <T> List<T> listeners(Injector src, Class<T> type) {
        List<Binding<T>> bindings = PluginGuiceEnvironment.bindings(src, TypeLiteral.get(type));
        int cnt = bindings != null ? bindings.size() : 0;
        ArrayList<T> found = Lists.newArrayListWithCapacity(cnt);
        if (bindings != null) {
            for (Binding<T> b : bindings) {
                found.add(b.getProvider().get());
            }
        }
        return found;
    }

    private static <T> List<Binding<T>> bindings(Injector src, TypeLiteral<T> type) {
        return src.findBindingsByType(type);
    }

    private Module copy(Injector src) {
        HashSet<TypeLiteral<?>> dynamicTypes = Sets.newHashSet();
        HashSet<TypeLiteral<?>> dynamicItemTypes = Sets.newHashSet();
        for (Map.Entry<Key<?>, Binding<?>> e : src.getBindings().entrySet()) {
            ParameterizedType t;
            TypeLiteral<?> type = e.getKey().getTypeLiteral();
            if (type.getRawType() == DynamicItem.class) {
                t = (ParameterizedType)type.getType();
                dynamicItemTypes.add(TypeLiteral.get(t.getActualTypeArguments()[0]));
                continue;
            }
            if (type.getRawType() != DynamicSet.class && type.getRawType() != DynamicMap.class) continue;
            t = (ParameterizedType)type.getType();
            dynamicTypes.add(TypeLiteral.get(t.getActualTypeArguments()[0]));
        }
        final LinkedHashMap<Key<?>, Binding<?>> bindings = Maps.newLinkedHashMap();
        for (Map.Entry<Key<?>, Binding<?>> e : src.getBindings().entrySet()) {
            if (dynamicTypes.contains(e.getKey().getTypeLiteral()) && e.getKey().getAnnotation() != null || dynamicItemTypes.contains(e.getKey().getTypeLiteral()) || !this.shouldCopy(e.getKey())) continue;
            bindings.put(e.getKey(), e.getValue());
        }
        bindings.remove(Key.get(Injector.class));
        bindings.remove(Key.get(Logger.class));
        final Binding<HttpServletRequest> requestBinding = src.getExistingBinding(Key.get(HttpServletRequest.class));
        final Binding<HttpServletResponse> responseBinding = src.getExistingBinding(Key.get(HttpServletResponse.class));
        return new AbstractModule(){

            @Override
            protected void configure() {
                for (Map.Entry e : bindings.entrySet()) {
                    Key k = (Key)e.getKey();
                    Binding b = (Binding)e.getValue();
                    this.bind(k).toProvider(b.getProvider());
                }
                if (requestBinding != null) {
                    this.bind(HttpServletRequest.class).annotatedWith(RootRelative.class).toProvider(requestBinding.getProvider());
                }
                if (responseBinding != null) {
                    this.bind(HttpServletResponse.class).annotatedWith(RootRelative.class).toProvider(responseBinding.getProvider());
                }
            }
        };
    }

    private boolean shouldCopy(Key<?> key) {
        if (this.copyConfigKeys.contains(key)) {
            return false;
        }
        Class<?> type = key.getTypeLiteral().getRawType();
        if (LifecycleListener.class.isAssignableFrom(type)) {
            return false;
        }
        if (StartPluginListener.class.isAssignableFrom(type)) {
            return false;
        }
        if (StopPluginListener.class.isAssignableFrom(type)) {
            return false;
        }
        if (type.getName().startsWith("com.google.inject.")) {
            return false;
        }
        if (PluginGuiceEnvironment.is("org.apache.sshd.server.Command", type)) {
            return false;
        }
        if (PluginGuiceEnvironment.is("javax.servlet.Filter", type)) {
            return false;
        }
        if (PluginGuiceEnvironment.is("javax.servlet.ServletContext", type)) {
            return false;
        }
        if (PluginGuiceEnvironment.is("javax.servlet.ServletRequest", type)) {
            return false;
        }
        if (PluginGuiceEnvironment.is("javax.servlet.ServletResponse", type)) {
            return false;
        }
        if (PluginGuiceEnvironment.is("javax.servlet.http.HttpServlet", type)) {
            return false;
        }
        if (PluginGuiceEnvironment.is("javax.servlet.http.HttpServletRequest", type)) {
            return false;
        }
        if (PluginGuiceEnvironment.is("javax.servlet.http.HttpServletResponse", type)) {
            return false;
        }
        if (PluginGuiceEnvironment.is("javax.servlet.http.HttpSession", type)) {
            return false;
        }
        if (Map.class.isAssignableFrom(type) && key.getAnnotationType() != null && "com.google.inject.servlet.RequestParameters".equals(key.getAnnotationType().getName())) {
            return false;
        }
        return !type.getName().startsWith("com.google.gerrit.httpd.GitOverHttpServlet$");
    }

    static boolean is(String name, Class<?> type) {
        while (type != null) {
            if (name.equals(type.getName())) {
                return true;
            }
            Class<?>[] interfaces = type.getInterfaces();
            if (interfaces != null) {
                for (Class<?> i : interfaces) {
                    if (!PluginGuiceEnvironment.is(name, i)) continue;
                    return true;
                }
            }
            type = type.getSuperclass();
        }
        return false;
    }
}

