/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.gerrit.server.plugins.PluginLoader;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class PluginScannerThread
extends Thread {
    private final CountDownLatch done = new CountDownLatch(1);
    private final PluginLoader loader;
    private final long checkFrequencyMillis;

    PluginScannerThread(PluginLoader loader, long checkFrequencyMillis) {
        this.loader = loader;
        this.checkFrequencyMillis = checkFrequencyMillis;
        this.setDaemon(true);
        this.setName("PluginScanner");
    }

    @Override
    public void run() {
        while (true) {
            try {
                if (this.done.await(this.checkFrequencyMillis, TimeUnit.MILLISECONDS)) {
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.loader.rescan();
        }
    }

    void end() {
        this.done.countDown();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

