/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.collect.Lists;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.common.data.PermissionRange;
import com.google.gerrit.common.data.RefConfigSection;
import com.google.gerrit.common.data.SubmitRecord;
import com.google.gerrit.common.data.SubmitTypeRecord;
import com.google.gerrit.extensions.common.SubmitType;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.RefControl;
import com.google.gerrit.server.project.RefPatternMatcher;
import com.google.gerrit.server.project.RuleEvalException;
import com.google.gerrit.server.project.SubmitRuleEvaluator;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.googlecode.prolog_cafe.lang.IntegerTerm;
import com.googlecode.prolog_cafe.lang.ListTerm;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.StructureTerm;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.Term;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeControl {
    private static final Logger log = LoggerFactory.getLogger(ChangeControl.class);
    private final ChangeData.Factory changeDataFactory;
    private final RefControl refControl;
    private final ChangeNotes notes;

    @AssistedInject
    ChangeControl(ChangeData.Factory changeDataFactory, ChangeNotes.Factory notesFactory, @Assisted RefControl refControl, @Assisted Change change) {
        this(changeDataFactory, refControl, notesFactory.create(change));
    }

    @AssistedInject
    ChangeControl(ChangeData.Factory changeDataFactory, @Assisted RefControl refControl, @Assisted ChangeNotes notes) {
        this.changeDataFactory = changeDataFactory;
        this.refControl = refControl;
        this.notes = notes;
    }

    public ChangeControl forUser(CurrentUser who) {
        if (this.getCurrentUser().equals(who)) {
            return this;
        }
        return new ChangeControl(this.changeDataFactory, this.getRefControl().forUser(who), this.notes);
    }

    public RefControl getRefControl() {
        return this.refControl;
    }

    public CurrentUser getCurrentUser() {
        return this.getRefControl().getCurrentUser();
    }

    public ProjectControl getProjectControl() {
        return this.getRefControl().getProjectControl();
    }

    public Project getProject() {
        return this.getProjectControl().getProject();
    }

    public Change getChange() {
        return this.notes.getChange();
    }

    public ChangeNotes getNotes() {
        return this.notes;
    }

    public boolean isVisible(ReviewDb db) throws OrmException {
        if (this.getChange().getStatus() == Change.Status.DRAFT && !this.isDraftVisible(db, null)) {
            return false;
        }
        return this.isRefVisible();
    }

    public boolean isRefVisible() {
        return this.getRefControl().isVisible();
    }

    public boolean isPatchVisible(PatchSet ps, ReviewDb db) throws OrmException {
        if (ps != null && ps.isDraft() && !this.isDraftVisible(db, null)) {
            return false;
        }
        return this.isVisible(db);
    }

    public boolean canAbandon() {
        return this.isOwner() || this.getRefControl().isOwner() || this.getProjectControl().isOwner() || this.getCurrentUser().getCapabilities().canAdministrateServer() || this.getRefControl().canAbandon();
    }

    public boolean canPublish(ReviewDb db) throws OrmException {
        return (this.isOwner() || this.getRefControl().canPublishDrafts()) && this.isVisible(db);
    }

    public boolean canDeleteDraft(ReviewDb db) throws OrmException {
        return (this.isOwner() || this.getRefControl().canDeleteDrafts()) && this.isVisible(db);
    }

    public boolean canRebase() {
        return this.isOwner() || this.getRefControl().canSubmit() || this.getRefControl().canRebase();
    }

    public boolean canRestore() {
        return this.canAbandon() && this.getRefControl().canUpload();
    }

    public LabelTypes getLabelTypes() {
        String destBranch = this.getChange().getDest().get();
        List<LabelType> all = this.getProjectControl().getLabelTypes().getLabelTypes();
        ArrayList<LabelType> r = Lists.newArrayListWithCapacity(all.size());
        block0: for (LabelType l : all) {
            List<String> refs = l.getRefPatterns();
            if (refs == null) {
                r.add(l);
                continue;
            }
            for (String refPattern : refs) {
                if (!RefConfigSection.isValid(refPattern) || !this.match(destBranch, refPattern)) continue;
                r.add(l);
                continue block0;
            }
        }
        return new LabelTypes(r);
    }

    public List<PermissionRange> getLabelRanges() {
        return this.getRefControl().getLabelRanges(this.isOwner());
    }

    public PermissionRange getRange(String permission) {
        return this.getRefControl().getRange(permission, this.isOwner());
    }

    public boolean canAddPatchSet() {
        return this.getRefControl().canUpload();
    }

    public boolean isOwner() {
        if (this.getCurrentUser().isIdentifiedUser()) {
            IdentifiedUser i = (IdentifiedUser)this.getCurrentUser();
            return i.getAccountId().equals(this.getChange().getOwner());
        }
        return false;
    }

    public boolean isReviewer(ReviewDb db) throws OrmException {
        return this.isReviewer(db, null);
    }

    public boolean isReviewer(ReviewDb db, @Nullable ChangeData cd) throws OrmException {
        if (this.getCurrentUser().isIdentifiedUser()) {
            Collection results = this.changeData(db, cd).reviewers().values();
            IdentifiedUser user = (IdentifiedUser)this.getCurrentUser();
            return results.contains(user.getAccountId());
        }
        return false;
    }

    public boolean canRemoveReviewer(PatchSetApproval approval) {
        return this.canRemoveReviewer(approval.getAccountId(), approval.getValue());
    }

    public boolean canRemoveReviewer(Account.Id reviewer, int value) {
        if (this.getChange().getStatus().isOpen()) {
            IdentifiedUser i;
            if (this.getCurrentUser().isIdentifiedUser() && (i = (IdentifiedUser)this.getCurrentUser()).getAccountId().equals(reviewer)) {
                return true;
            }
            if (this.isOwner() && 0 <= value) {
                return true;
            }
            if (this.getRefControl().canRemoveReviewer() || this.getRefControl().isOwner() || this.getProjectControl().isOwner() || this.getCurrentUser().getCapabilities().canAdministrateServer()) {
                return true;
            }
        }
        return false;
    }

    public boolean canEditTopicName() {
        if (this.getChange().getStatus().isOpen()) {
            return this.isOwner() || this.getRefControl().isOwner() || this.getProjectControl().isOwner() || this.getCurrentUser().getCapabilities().canAdministrateServer() || this.getRefControl().canEditTopicName();
        }
        return this.getRefControl().canForceEditTopicName();
    }

    public List<SubmitRecord> getSubmitRecords(ReviewDb db, PatchSet patchSet) {
        return this.canSubmit(db, patchSet, null, false, true, false);
    }

    public boolean canSubmit() {
        return this.getRefControl().canSubmit();
    }

    public boolean canSubmitAs() {
        return this.getRefControl().canSubmitAs();
    }

    public List<SubmitRecord> canSubmit(ReviewDb db, PatchSet patchSet) {
        return this.canSubmit(db, patchSet, null, false, false, false);
    }

    public List<SubmitRecord> canSubmit(ReviewDb db, PatchSet patchSet, @Nullable ChangeData cd, boolean fastEvalLabels, boolean allowClosed, boolean allowDraft) {
        List<Term> results;
        SubmitRuleEvaluator evaluator;
        if (!allowClosed && this.getChange().getStatus().isClosed()) {
            SubmitRecord rec = new SubmitRecord();
            rec.status = SubmitRecord.Status.CLOSED;
            return Collections.singletonList(rec);
        }
        if (!patchSet.getId().equals(this.getChange().currentPatchSetId())) {
            return this.ruleError("Patch set " + patchSet.getPatchSetId() + " is not current");
        }
        cd = this.changeData(db, cd);
        if ((this.getChange().getStatus() == Change.Status.DRAFT || patchSet.isDraft()) && !allowDraft) {
            return this.cannotSubmitDraft(db, patchSet, cd);
        }
        try {
            evaluator = new SubmitRuleEvaluator(db, patchSet, this.getProjectControl(), this, this.getChange(), cd, fastEvalLabels, "locate_submit_rule", "can_submit", "locate_submit_filter", "filter_submit_results");
            results = evaluator.evaluate();
        }
        catch (RuleEvalException e) {
            return this.logRuleError(e.getMessage(), e);
        }
        if (results.isEmpty()) {
            log.error("Submit rule '" + evaluator.getSubmitRule() + "' for change " + this.getChange().getId() + " of " + this.getProject().getName() + " has no solution.");
            return this.ruleError("Project submit rule has no solution");
        }
        return this.resultsToSubmitRecord(evaluator.getSubmitRule(), results);
    }

    private boolean match(String destBranch, String refPattern) {
        return RefPatternMatcher.getMatcher(refPattern).match(destBranch, this.getRefControl().getCurrentUser().getUserName());
    }

    private List<SubmitRecord> cannotSubmitDraft(ReviewDb db, PatchSet patchSet, @Nullable ChangeData cd) {
        try {
            if (!this.isDraftVisible(db, cd)) {
                return this.ruleError("Patch set " + patchSet.getPatchSetId() + " not found");
            }
            if (patchSet.isDraft()) {
                return this.ruleError("Cannot submit draft patch sets");
            }
            return this.ruleError("Cannot submit draft changes");
        }
        catch (OrmException err) {
            return this.logRuleError("Cannot read patch set " + patchSet.getId(), err);
        }
    }

    public List<SubmitRecord> resultsToSubmitRecord(Term submitRule, List<Term> results) {
        ArrayList<SubmitRecord> out = new ArrayList<SubmitRecord>(results.size());
        for (int resultIdx = results.size() - 1; 0 <= resultIdx; --resultIdx) {
            Term submitRecord = results.get(resultIdx);
            SubmitRecord rec = new SubmitRecord();
            out.add(rec);
            if (!submitRecord.isStructure() || 1 != submitRecord.arity()) {
                return this.logInvalidResult(submitRule, submitRecord);
            }
            if ("ok".equals(submitRecord.name())) {
                rec.status = SubmitRecord.Status.OK;
            } else if ("not_ready".equals(submitRecord.name())) {
                rec.status = SubmitRecord.Status.NOT_READY;
            } else {
                return this.logInvalidResult(submitRule, submitRecord);
            }
            submitRecord = submitRecord.arg(0);
            if (!submitRecord.isStructure()) {
                return this.logInvalidResult(submitRule, submitRecord);
            }
            rec.labels = new ArrayList<SubmitRecord.Label>(submitRecord.arity());
            for (Term state : ((StructureTerm)submitRecord).args()) {
                if (!state.isStructure() || 2 != state.arity() || !"label".equals(state.name())) {
                    return this.logInvalidResult(submitRule, submitRecord);
                }
                SubmitRecord.Label lbl = new SubmitRecord.Label();
                rec.labels.add(lbl);
                lbl.label = state.arg(0).name();
                Term status = state.arg(1);
                try {
                    if ("ok".equals(status.name())) {
                        lbl.status = SubmitRecord.Label.Status.OK;
                        this.appliedBy(lbl, status);
                        continue;
                    }
                    if ("reject".equals(status.name())) {
                        lbl.status = SubmitRecord.Label.Status.REJECT;
                        this.appliedBy(lbl, status);
                        continue;
                    }
                    if ("need".equals(status.name())) {
                        lbl.status = SubmitRecord.Label.Status.NEED;
                        continue;
                    }
                    if ("may".equals(status.name())) {
                        lbl.status = SubmitRecord.Label.Status.MAY;
                        continue;
                    }
                    if ("impossible".equals(status.name())) {
                        lbl.status = SubmitRecord.Label.Status.IMPOSSIBLE;
                        continue;
                    }
                    return this.logInvalidResult(submitRule, submitRecord);
                }
                catch (UserTermExpected e) {
                    return this.logInvalidResult(submitRule, submitRecord, e.getMessage());
                }
            }
            if (rec.status == SubmitRecord.Status.OK) break;
        }
        Collections.reverse(out);
        return out;
    }

    public SubmitTypeRecord getSubmitTypeRecord(ReviewDb db, PatchSet patchSet) {
        return this.getSubmitTypeRecord(db, patchSet, null);
    }

    public SubmitTypeRecord getSubmitTypeRecord(ReviewDb db, PatchSet patchSet, @Nullable ChangeData cd) {
        List<Term> results;
        SubmitRuleEvaluator evaluator;
        cd = this.changeData(db, cd);
        try {
            if (this.getChange().getStatus() == Change.Status.DRAFT && !this.isDraftVisible(db, cd)) {
                return this.typeRuleError("Patch set " + patchSet.getPatchSetId() + " not found");
            }
            if (patchSet.isDraft() && !this.isDraftVisible(db, cd)) {
                return this.typeRuleError("Patch set " + patchSet.getPatchSetId() + " not found");
            }
        }
        catch (OrmException err) {
            return this.logTypeRuleError("Cannot read patch set " + patchSet.getId(), err);
        }
        try {
            evaluator = new SubmitRuleEvaluator(db, patchSet, this.getProjectControl(), this, this.getChange(), cd, false, "locate_submit_type", "get_submit_type", "locate_submit_type_filter", "filter_submit_type_results");
            results = evaluator.evaluate();
        }
        catch (RuleEvalException e) {
            return this.logTypeRuleError(e.getMessage(), e);
        }
        if (results.isEmpty()) {
            log.error("Submit rule '" + evaluator.getSubmitRule() + "' for change " + this.getChange().getId() + " of " + this.getProject().getName() + " has no solution.");
            return this.typeRuleError("Project submit rule has no solution");
        }
        Term typeTerm = results.get(0);
        if (!typeTerm.isSymbol()) {
            log.error("Submit rule '" + evaluator.getSubmitRule() + "' for change " + this.getChange().getId() + " of " + this.getProject().getName() + " did not return a symbol.");
            return this.typeRuleError("Project submit rule has invalid solution");
        }
        String typeName = ((SymbolTerm)typeTerm).name();
        try {
            return SubmitTypeRecord.OK(SubmitType.valueOf(typeName.toUpperCase()));
        }
        catch (IllegalArgumentException e) {
            return this.logInvalidType(evaluator.getSubmitRule(), typeName);
        }
    }

    private List<SubmitRecord> logInvalidResult(Term rule, Term record, String reason) {
        return this.logRuleError("Submit rule " + rule + " for change " + this.getChange().getId() + " of " + this.getProject().getName() + " output invalid result: " + record + (reason == null ? "" : ". Reason: " + reason));
    }

    private List<SubmitRecord> logInvalidResult(Term rule, Term record) {
        return this.logInvalidResult(rule, record, null);
    }

    private List<SubmitRecord> logRuleError(String err, Exception e) {
        log.error(err, e);
        return this.ruleError("Error evaluating project rules, check server log");
    }

    private List<SubmitRecord> logRuleError(String err) {
        log.error(err);
        return this.ruleError("Error evaluating project rules, check server log");
    }

    private List<SubmitRecord> ruleError(String err) {
        SubmitRecord rec = new SubmitRecord();
        rec.status = SubmitRecord.Status.RULE_ERROR;
        rec.errorMessage = err;
        return Collections.singletonList(rec);
    }

    private SubmitTypeRecord logInvalidType(Term rule, String record) {
        return this.logTypeRuleError("Submit type rule " + rule + " for change " + this.getChange().getId() + " of " + this.getProject().getName() + " output invalid result: " + record);
    }

    private SubmitTypeRecord logTypeRuleError(String err, Exception e) {
        log.error(err, e);
        return this.typeRuleError("Error evaluating project type rules, check server log");
    }

    private SubmitTypeRecord logTypeRuleError(String err) {
        log.error(err);
        return this.typeRuleError("Error evaluating project type rules, check server log");
    }

    private SubmitTypeRecord typeRuleError(String err) {
        SubmitTypeRecord rec = new SubmitTypeRecord();
        rec.status = SubmitTypeRecord.Status.RULE_ERROR;
        rec.errorMessage = err;
        return rec;
    }

    private ChangeData changeData(ReviewDb db, @Nullable ChangeData cd) {
        return cd != null ? cd : this.changeDataFactory.create(db, this);
    }

    private void appliedBy(SubmitRecord.Label label, Term status) throws UserTermExpected {
        if (status.isStructure() && status.arity() == 1) {
            Term who = status.arg(0);
            if (ChangeControl.isUser(who)) {
                label.appliedBy = new Account.Id(((IntegerTerm)who.arg(0)).intValue());
            } else {
                throw new UserTermExpected(label);
            }
        }
    }

    private boolean isDraftVisible(ReviewDb db, ChangeData cd) throws OrmException {
        return this.isOwner() || this.isReviewer(db, cd) || this.getRefControl().canViewDrafts();
    }

    private static boolean isUser(Term who) {
        return who.isStructure() && who.arity() == 1 && who.name().equals("user") && who.arg(0).isInteger();
    }

    public static Term toListTerm(List<Term> terms) {
        Term list = Prolog.Nil;
        for (int i = terms.size() - 1; i >= 0; --i) {
            list = new ListTerm(terms.get(i), list);
        }
        return list;
    }

    private static class UserTermExpected
    extends Exception {
        private static final long serialVersionUID = 1L;

        public UserTermExpected(SubmitRecord.Label label) {
            super(String.format("A label with the status %s must contain a user.", label.toString()));
        }
    }

    public static interface AssistedFactory {
        public ChangeControl create(RefControl var1, Change var2);

        public ChangeControl create(RefControl var1, ChangeNotes var2);
    }

    public static class Factory {
        private final ProjectControl.Factory projectControl;
        private final Provider<ReviewDb> db;

        @Inject
        Factory(ProjectControl.Factory p, Provider<ReviewDb> d) {
            this.projectControl = p;
            this.db = d;
        }

        public ChangeControl controlFor(Change.Id id) throws NoSuchChangeException {
            Change change;
            try {
                change = this.db.get().changes().get(id);
                if (change == null) {
                    throw new NoSuchChangeException(id);
                }
            }
            catch (OrmException e) {
                throw new NoSuchChangeException(id, (Throwable)e);
            }
            return this.controlFor(change);
        }

        public ChangeControl controlFor(Change change) throws NoSuchChangeException {
            try {
                Project.NameKey projectKey = change.getProject();
                return this.projectControl.validateFor(projectKey).controlFor(change);
            }
            catch (NoSuchProjectException e) {
                throw new NoSuchChangeException(change.getId(), (Throwable)e);
            }
        }

        public ChangeControl validateFor(Change.Id id) throws NoSuchChangeException, OrmException {
            return Factory.validate(this.controlFor(id), this.db.get());
        }

        public ChangeControl validateFor(Change change) throws NoSuchChangeException, OrmException {
            return Factory.validate(this.controlFor(change), this.db.get());
        }

        private static ChangeControl validate(ChangeControl c, ReviewDb db) throws NoSuchChangeException, OrmException {
            if (!c.isVisible(db)) {
                throw new NoSuchChangeException(c.getChange().getId());
            }
            return c;
        }
    }

    public static class GenericFactory {
        private final ProjectControl.GenericFactory projectControl;
        private final Provider<ReviewDb> db;

        @Inject
        GenericFactory(ProjectControl.GenericFactory p, Provider<ReviewDb> d) {
            this.projectControl = p;
            this.db = d;
        }

        public ChangeControl controlFor(Change change, CurrentUser user) throws NoSuchChangeException {
            Project.NameKey projectKey = change.getProject();
            try {
                return this.projectControl.controlFor(projectKey, user).controlFor(change);
            }
            catch (NoSuchProjectException e) {
                throw new NoSuchChangeException(change.getId(), (Throwable)e);
            }
            catch (IOException e) {
                throw new NoSuchChangeException(change.getId(), (Throwable)e);
            }
        }

        public ChangeControl controlFor(Change.Id id, CurrentUser user) throws NoSuchChangeException {
            Change change;
            try {
                change = this.db.get().changes().get(id);
                if (change == null) {
                    throw new NoSuchChangeException(id);
                }
            }
            catch (OrmException e) {
                throw new NoSuchChangeException(id, (Throwable)e);
            }
            return this.controlFor(change, user);
        }

        public ChangeControl validateFor(Change change, CurrentUser user) throws NoSuchChangeException, OrmException {
            ChangeControl c = this.controlFor(change, user);
            if (!c.isVisible(this.db.get())) {
                throw new NoSuchChangeException(c.getChange().getId());
            }
            return c;
        }

        public ChangeControl validateFor(Change.Id id, CurrentUser user) throws NoSuchChangeException, OrmException {
            ChangeControl c = this.controlFor(id, user);
            if (!c.isVisible(this.db.get())) {
                throw new NoSuchChangeException(c.getChange().getId());
            }
            return c;
        }
    }
}

