/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.common.ProjectInfo;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.project.ChildProjectResource;
import com.google.gerrit.server.project.ProjectJson;
import com.google.inject.Inject;
import org.kohsuke.args4j.Option;

public class GetChildProject
implements RestReadView<ChildProjectResource> {
    @Option(name="--recursive", usage="to list child projects recursively")
    private boolean recursive;
    private final ProjectJson json;

    @Inject
    GetChildProject(ProjectJson json) {
        this.json = json;
    }

    public ProjectInfo apply(ChildProjectResource rsrc) throws ResourceNotFoundException {
        if (this.recursive || rsrc.isDirectChild()) {
            return this.json.format(rsrc.getChild().getProject());
        }
        throw new ResourceNotFoundException(rsrc.getName());
    }
}

