/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.config.AllProjectsNameProvider;
import com.google.gerrit.server.config.PluginConfigFactory;
import com.google.gerrit.server.config.ProjectConfigEntry;
import com.google.gerrit.server.git.TransferConfig;
import com.google.gerrit.server.project.ConfigInfo;
import com.google.gerrit.server.project.ProjectResource;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
public class GetConfig
implements RestReadView<ProjectResource> {
    private final TransferConfig config;
    private final DynamicMap<ProjectConfigEntry> pluginConfigEntries;
    private final PluginConfigFactory cfgFactory;
    private final AllProjectsNameProvider allProjects;
    private final DynamicMap<RestView<ProjectResource>> views;

    @Inject
    public GetConfig(TransferConfig config, DynamicMap<ProjectConfigEntry> pluginConfigEntries, PluginConfigFactory cfgFactory, AllProjectsNameProvider allProjects, DynamicMap<RestView<ProjectResource>> views, Provider<CurrentUser> currentUser) {
        this.config = config;
        this.pluginConfigEntries = pluginConfigEntries;
        this.allProjects = allProjects;
        this.cfgFactory = cfgFactory;
        this.views = views;
    }

    public ConfigInfo apply(ProjectResource resource) {
        return new ConfigInfo(resource.getControl(), this.config, this.pluginConfigEntries, this.cfgFactory, this.allProjects, this.views);
    }
}

