/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectState;
import com.google.inject.Inject;
import com.google.inject.servlet.RequestScoped;
import java.util.HashMap;
import java.util.Map;

@RequestScoped
public class PerRequestProjectControlCache {
    private final ProjectCache projectCache;
    private final CurrentUser user;
    private final Map<Project.NameKey, ProjectControl> controls;

    @Inject
    PerRequestProjectControlCache(ProjectCache projectCache, CurrentUser userProvider) {
        this.projectCache = projectCache;
        this.user = userProvider;
        this.controls = new HashMap<Project.NameKey, ProjectControl>();
    }

    ProjectControl get(Project.NameKey nameKey) throws NoSuchProjectException {
        ProjectControl ctl = this.controls.get(nameKey);
        if (ctl == null) {
            ProjectState p = this.projectCache.get(nameKey);
            if (p == null) {
                throw new NoSuchProjectException(nameKey);
            }
            ctl = p.controlFor(this.user);
            this.controls.put(nameKey, ctl);
        }
        return ctl;
    }

    public void evict(Project project) {
        this.projectCache.evict(project);
        this.controls.remove(project.getNameKey());
    }
}

