/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.project.ProjectRef;
import com.google.gerrit.server.project.RefControl;
import com.google.gerrit.server.project.RefPatternMatcher;
import com.google.gerrit.server.project.SectionMatcher;
import com.google.gerrit.server.project.SectionSortCache;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PermissionCollection {
    private final Map<String, List<PermissionRule>> rules;
    private final Map<String, List<PermissionRule>> overridden;
    private final Map<PermissionRule, ProjectRef> ruleProps;
    private final boolean perUser;

    private PermissionCollection(Map<String, List<PermissionRule>> rules, Map<String, List<PermissionRule>> overridden, Map<PermissionRule, ProjectRef> ruleProps, boolean perUser) {
        this.rules = rules;
        this.overridden = overridden;
        this.ruleProps = ruleProps;
        this.perUser = perUser;
    }

    public boolean isUserSpecific() {
        return this.perUser;
    }

    public List<PermissionRule> getPermission(String permissionName) {
        List<PermissionRule> r = this.rules.get(permissionName);
        return r != null ? r : Collections.emptyList();
    }

    List<PermissionRule> getOverridden(String permissionName) {
        return Objects.firstNonNull(this.overridden.get(permissionName), Collections.emptyList());
    }

    ProjectRef getRuleProps(PermissionRule rule) {
        return this.ruleProps.get(rule);
    }

    public Iterable<Map.Entry<String, List<PermissionRule>>> getDeclaredPermissions() {
        return this.rules.entrySet();
    }

    private static class SeenRule {
        final String refPattern;
        final String permissionName;
        final AccountGroup.UUID group;

        SeenRule(AccessSection section, Permission permission, PermissionRule rule) {
            this.refPattern = section.getName();
            this.permissionName = permission.getName();
            this.group = rule.getGroup().getUUID();
        }

        public int hashCode() {
            int hc = this.refPattern.hashCode();
            hc = hc * 31 + this.permissionName.hashCode();
            if (this.group != null) {
                hc = hc * 31 + this.group.hashCode();
            }
            return hc;
        }

        public boolean equals(Object other) {
            if (other instanceof SeenRule) {
                SeenRule a = this;
                SeenRule b = (SeenRule)other;
                return a.refPattern.equals(b.refPattern) && a.permissionName.equals(b.permissionName) && this.eq(a.group, b.group);
            }
            return false;
        }

        private boolean eq(AccountGroup.UUID a, AccountGroup.UUID b) {
            return a != null && b != null && a.equals(b);
        }
    }

    @Singleton
    public static class Factory {
        private final SectionSortCache sorter;

        @Inject
        Factory(SectionSortCache sorter) {
            this.sorter = sorter;
        }

        PermissionCollection filter(Iterable<SectionMatcher> matcherList, String ref, Collection<String> usernames) {
            if (RefControl.isRE(ref)) {
                ref = RefControl.shortestExample(ref);
            } else if (ref.endsWith("/*")) {
                ref = ref.substring(0, ref.length() - 1);
            }
            boolean hasUsernames = usernames != null && !usernames.isEmpty();
            boolean perUser = false;
            LinkedHashMap<AccessSection, Project.NameKey> sectionToProject = Maps.newLinkedHashMap();
            block0: for (SectionMatcher sm : matcherList) {
                if (hasUsernames) {
                    if (!perUser && sm.matcher instanceof RefPatternMatcher.ExpandParameters) {
                        perUser = ((RefPatternMatcher.ExpandParameters)sm.matcher).matchPrefix(ref);
                    }
                    for (String username : usernames) {
                        if (!sm.match(ref, username)) continue;
                        sectionToProject.put(sm.section, sm.project);
                        continue block0;
                    }
                    continue;
                }
                if (!sm.match(ref, null)) continue;
                sectionToProject.put(sm.section, sm.project);
            }
            ArrayList<AccessSection> sections = Lists.newArrayList(sectionToProject.keySet());
            this.sorter.sort(ref, sections);
            HashSet<SeenRule> seen = new HashSet<SeenRule>();
            HashSet<String> exclusiveGroupPermissions = new HashSet<String>();
            HashMap<String, ArrayList<PermissionRule>> permissions = new HashMap<String, ArrayList<PermissionRule>>();
            HashMap overridden = new HashMap();
            IdentityHashMap<PermissionRule, ProjectRef> ruleProps = Maps.newIdentityHashMap();
            for (AccessSection section : sections) {
                Project.NameKey project = (Project.NameKey)sectionToProject.get(section);
                for (Permission permission : section.getPermissions()) {
                    boolean exclusivePermissionExists = exclusiveGroupPermissions.contains(permission.getName());
                    for (PermissionRule rule : permission.getRules()) {
                        SeenRule s = new SeenRule(section, permission, rule);
                        boolean addRule = rule.isBlock() ? true : seen.add(s) && !rule.isDeny() && !exclusivePermissionExists;
                        HashMap<String, ArrayList<PermissionRule>> p = null;
                        if (addRule) {
                            p = permissions;
                        } else if (!rule.isDeny() && !exclusivePermissionExists) {
                            p = overridden;
                        }
                        if (p == null) continue;
                        ArrayList<PermissionRule> r = (ArrayList<PermissionRule>)p.get(permission.getName());
                        if (r == null) {
                            r = new ArrayList<PermissionRule>(2);
                            p.put(permission.getName(), r);
                        }
                        r.add(rule);
                        ruleProps.put(rule, new ProjectRef(project, section.getName()));
                    }
                    if (!permission.getExclusiveGroup().booleanValue()) continue;
                    exclusiveGroupPermissions.add(permission.getName());
                }
            }
            return new PermissionCollection(permissions, overridden, ruleProps, perUser);
        }
    }
}

